/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.websocket.DeploymentException;
import javax.ws.rs.shaded.client.WebTarget;
import org.apache.log4j.Logger;
import org.glassfish.jersey.shaded.uri.UriComponent;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.exceptions.ChannelNotFoundException;
import org.mule.modules.slack.client.exceptions.UserNotFoundException;
import org.mule.modules.slack.client.model.User;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.chat.MessageResponse;
import org.mule.modules.slack.client.model.chat.attachment.ChatAttachment;
import org.mule.modules.slack.client.model.file.FileUploadResponse;
import org.mule.modules.slack.client.model.group.Group;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;
import org.mule.modules.slack.client.model.im.DirectMessageChannelCreationResponse;
import org.mule.modules.slack.client.rtm.EventHandler;
import org.mule.modules.slack.client.rtm.SlackMessageHandler;

public class SlackClient {
    private String token;
    private Gson mapper;
    private SlackRequester slackRequester;
    private SlackMessageHandler slackMessageHandler;
    private static final Logger logger = Logger.getLogger(SlackClient.class);
    private String selfId;

    public SlackClient(String token) {
        this.slackRequester = new SlackRequester(token);
        this.token = token;
        this.mapper = new Gson();
    }

    public String testAuth() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("auth.test");
        return SlackRequester.sendRequest(webTarget);
    }

    public String getSelfId() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("auth.test");
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = new JSONObject(output);
        return slackResponse.getString("user_id");
    }

    public Boolean isConnected() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("auth.test");
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = new JSONObject(output);
        return slackResponse.getBoolean("ok");
    }

    public List<Channel> getChannelList() {
        ArrayList<Channel> list = new ArrayList<Channel>();
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray channels = (JSONArray)new JSONObject(output).get("channels");
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = (JSONObject)channels.get(i);
            Channel newChannel = (Channel)this.mapper.fromJson(channel.toString(), Channel.class);
            list.add(newChannel);
        }
        return list;
    }

    public Boolean leaveChannel(String channelId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.leave").queryParam("channel", channelId);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Channel getChannelById(String id) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.info").queryParam("channel", id);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.mapper.fromJson(slackResponse.toString(), Channel.class);
    }

    public List<Message> getChannelHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "channels.history");
    }

    public Channel createChannel(String channelName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.create").queryParam("name", channelName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.mapper.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel renameChannel(String channelId, String newName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.rename").queryParam("name", newName).queryParam("channel", channelId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.mapper.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel joinChannel(String channelName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.join").queryParam("name", channelName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.mapper.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel getChannelByName(String name) {
        List<Channel> list = this.getChannelList();
        for (Channel channel : list) {
            if (!channel.getName().equals(name)) continue;
            return channel;
        }
        throw new ChannelNotFoundException("Channel: " + name + " does not exist.");
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.setPurpose").queryParam("channel", channelID).queryParam("purpose", purpose);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.setTopic").queryParam("channel", channelID).queryParam("topic", topic);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewChannel(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromChannel(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.kick").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToChannel(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.invite").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.unarchive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.archive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public User getUserInfo(String id) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("users.info").queryParam("user", id);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("user");
        return (User)this.mapper.fromJson(slackResponse.toString(), User.class);
    }

    public List<User> getUserList() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("users.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("members");
        Type listType = new TypeToken<ArrayList<User>>(){}.getType();
        return (List)this.mapper.fromJson(slackResponse.toString(), listType);
    }

    public User getUserInfoByName(String username) throws UserNotFoundException {
        List<User> list = this.getUserList();
        for (User user : list) {
            if (!user.getName().equals(username)) continue;
            return user;
        }
        throw new UserNotFoundException("The user: " + username + " does not exist, please check the name!");
    }

    public MessageResponse sendMessage(String message, String channelId, String username, String iconUrl, Boolean asUser) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.postMessage").queryParam("channel", channelId).queryParam("text", UriComponent.encode(message, UriComponent.Type.QUERY_PARAM_SPACE_ENCODED)).queryParam("username", username).queryParam("icon_url", iconUrl).queryParam("as_user", String.valueOf(asUser));
        String output = SlackRequester.sendRequest(webTarget);
        return (MessageResponse)this.mapper.fromJson(output, MessageResponse.class);
    }

    public MessageResponse sendMessageWithAttachment(String message, String channelId, String username, String iconUrl, List<ChatAttachment> chatAttachmentArrayList, Boolean asUser) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.postMessage").queryParam("channel", channelId).queryParam("text", message).queryParam("username", username).queryParam("icon_url", iconUrl).queryParam("as_user", String.valueOf(asUser));
        webTarget = webTarget.queryParam("attachments", UriComponent.encode(this.mapper.toJson(chatAttachmentArrayList), UriComponent.Type.QUERY_PARAM_SPACE_ENCODED));
        String output = SlackRequester.sendRequest(webTarget);
        return (MessageResponse)this.mapper.fromJson(output, MessageResponse.class);
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.delete").queryParam("channel", channelId).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.update").queryParam("channel", channelId).queryParam("text", message).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public DirectMessageChannelCreationResponse openDirectMessageChannel(String userId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.open").queryParam("user", userId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (DirectMessageChannelCreationResponse)this.mapper.fromJson(slackResponse.toString(), DirectMessageChannelCreationResponse.class);
    }

    public List<DirectMessageChannel> getDirectMessageChannelsList() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("ims");
        Type listType = new TypeToken<ArrayList<DirectMessageChannel>>(){}.getType();
        return (List)this.mapper.fromJson(slackResponse.toString(), listType);
    }

    public List<Message> getDirectChannelHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "im.history");
    }

    public Boolean markViewDirectMessageChannel(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean closeDirectMessageChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.close").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public List<Message> getGroupHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "groups.history");
    }

    public List<Group> getGroupList() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("groups");
        Type listType = new TypeToken<ArrayList<Group>>(){}.getType();
        return (List)this.mapper.fromJson(slackResponse.toString(), listType);
    }

    public Group createGroup(String name) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.create").queryParam("name", name);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.mapper.fromJson(slackResponse.toString(), Group.class);
    }

    public Boolean openGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.open").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean leaveGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.leave").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.archive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.setPurpose").queryParam("channel", channelID).queryParam("purpose", purpose);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.setTopic").queryParam("channel", channelID).queryParam("topic", topic);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean closeGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.close").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewGroup(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromGroup(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.kick").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToGroup(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.invite").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveGroup(String groupID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.unarchive").queryParam("channel", groupID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Group renameGroup(String channelId, String newName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.rename").queryParam("channel", channelId).queryParam("name", newName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Group)this.mapper.fromJson(slackResponse.toString(), Group.class);
    }

    public Group getGroupInfo(String groupId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.info").queryParam("channel", groupId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.mapper.fromJson(slackResponse.toString(), Group.class);
    }

    public FileUploadResponse sendFile(String channelId, String fileName, String fileType, String title, String initialComment, InputStream file) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("files.upload").queryParam("channels", channelId).queryParam("filename", fileName).queryParam("filetype", fileType).queryParam("title", title).queryParam("initial_comment", initialComment);
        String stringResponse = SlackRequester.sendRequestWithFile(webTarget, file);
        return (FileUploadResponse)this.mapper.fromJson(new JSONObject(stringResponse).getJSONObject("file").toString(), FileUploadResponse.class);
    }

    public FileUploadResponse sendFile(String channelId, String fileName, String fileType, String title, String initialComment, String filePath) throws IOException {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("files.upload").queryParam("channels", channelId).queryParam("filename", fileName).queryParam("filetype", fileType).queryParam("title", title).queryParam("initial_comment", initialComment);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new IOException("File " + file.getAbsolutePath() + " does not exist!");
        }
        String stringResponse = SlackRequester.sendAttachmentRequest(webTarget, file);
        return (FileUploadResponse)this.mapper.fromJson(new JSONObject(stringResponse).getJSONObject("file").toString(), FileUploadResponse.class);
    }

    public String getWebSockerURI() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("rtm.start");
        String s = SlackRequester.sendRequest(webTarget);
        this.selfId = new JSONObject(s).getJSONObject("self").getString("id");
        return new JSONObject(s).getString("url");
    }

    public void startRealTimeCommunication(EventHandler messageHandler) throws DeploymentException, InterruptedException, IOException {
        this.slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI());
        this.slackMessageHandler.messageHandler = messageHandler;
        while (true) {
            try {
                while (true) {
                    this.slackMessageHandler.connect();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error Cause: ", (Throwable)e);
                logger.warn((Object)"Retrying RTM Communication in 20 Seconds");
                Thread.sleep(20000L);
                logger.warn((Object)"Starting RTM Communication");
                this.slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI());
                this.slackMessageHandler.messageHandler = messageHandler;
                continue;
            }
            break;
        }
    }

    public SlackMessageHandler getSlackMessageHandler() {
        return this.slackMessageHandler;
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path(operation).queryParam("channel", channelId).queryParam("latest", latest).queryParam("oldest", oldest).queryParam("count", count);
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.mapper.fromJson(slackResponse.toString(), listType);
    }

    private String getURL(String operation) {
        return "https://slack.com/api/" + operation + "?token=" + this.token;
    }
}

