/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import java.io.File;
import java.io.InputStream;
import javax.ws.rs.shaded.client.Client;
import javax.ws.rs.shaded.client.ClientBuilder;
import javax.ws.rs.shaded.client.Entity;
import javax.ws.rs.shaded.client.Invocation;
import javax.ws.rs.shaded.client.WebTarget;
import javax.ws.rs.shaded.core.Configurable;
import javax.ws.rs.shaded.core.Configuration;
import javax.ws.rs.shaded.core.MediaType;
import javax.ws.rs.shaded.core.Response;
import org.glassfish.jersey.shaded.client.ClientConfig;
import org.glassfish.jersey.shaded.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.shaded.media.multipart.MultiPartFeature;
import org.glassfish.jersey.shaded.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.shaded.media.multipart.file.StreamDataBodyPart;
import org.mule.modules.slack.client.ErrorHandler;

public class SlackRequester {
    String token;

    public SlackRequester(String token) {
        this.token = token;
    }

    public WebTarget getWebTarget() {
        Configurable clientConfig = new ClientConfig().register((Class)MultiPartFeature.class);
        Client client = ClientBuilder.newClient((Configuration)((Object)clientConfig));
        return client.target("https://slack.com/api/").queryParam("token", this.token);
    }

    public static String sendRequest(WebTarget webTarget) {
        Invocation.Builder invocationBuilder = webTarget.request("application/json");
        Response response = invocationBuilder.get();
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        String output = response.readEntity(String.class);
        ErrorHandler.verifyResponse(output);
        return output;
    }

    public static String sendRequestWithFile(WebTarget webTarget, InputStream file) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart(new StreamDataBodyPart("file", file, null, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        Response response = webTarget.request("multipart/form-data").post(Entity.entity(multiPart, multiPart.getMediaType()));
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        String output = response.readEntity(String.class);
        ErrorHandler.verifyResponse(output);
        return output;
    }

    public static String sendAttachmentRequest(WebTarget webTarget, File file) {
        FormDataMultiPart multiPart = new FormDataMultiPart();
        multiPart.bodyPart(new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
        Response response = webTarget.request("multipart/form-data").post(Entity.entity(multiPart, multiPart.getMediaType()));
        if (response.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        String output = response.readEntity(String.class);
        ErrorHandler.verifyResponse(output);
        return output;
    }
}

