/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.generated.adapters;

import java.util.ArrayList;
import java.util.List;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.devkit.3.8.0.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.3.8.0.internal.metadata.MetaDataGeneratorUtils;
import org.mule.modules.slack.config.SlackTokenConfig;
import org.mule.modules.slack.generated.adapters.SlackConnectorProcessAdapter;
import org.mule.modules.slack.metadata.AllChannelCategory;
import org.mule.modules.slack.metadata.ChannelCategory;
import org.mule.modules.slack.metadata.GroupCategory;
import org.mule.modules.slack.metadata.UserCategory;

public class SlackConnectorSlackTokenConfigBasicAdapter
extends SlackConnectorProcessAdapter
implements Testable,
ConnectorMetaDataEnabled {
    public TestResult test() {
        DefaultTestResult result;
        try {
            ((SlackTokenConfig)this.getSlackConfig()).connect();
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        return result;
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        try {
            ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
            GroupCategory groupCategory = new GroupCategory();
            groupCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(groupCategory.getEntities(), "GroupCategory"));
            AllChannelCategory allChannelCategory = new AllChannelCategory();
            allChannelCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(allChannelCategory.getEntities(), "AllChannelCategory"));
            ChannelCategory channelCategory = new ChannelCategory();
            channelCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(channelCategory.getEntities(), "ChannelCategory"));
            UserCategory userCategory = new UserCategory();
            userCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(userCategory.getEntities(), "UserCategory"));
            return new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        try {
            MetaData metaData = null;
            TypeDescribingProperty property = (TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class);
            String category = ((DefaultMetaDataKey)metaDataKey).getCategory();
            if (category == null) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[GroupCategory, AllChannelCategory, ChannelCategory, UserCategory]");
            if (category.equals("GroupCategory")) {
                GroupCategory groupCategory = new GroupCategory();
                groupCategory.setMyconnector(this);
                metaData = groupCategory.describeEntity(metaDataKey);
            } else if (category.equals("AllChannelCategory")) {
                AllChannelCategory allChannelCategory = new AllChannelCategory();
                allChannelCategory.setMyconnector(this);
                metaData = allChannelCategory.describeEntity(metaDataKey);
            } else if (category.equals("ChannelCategory")) {
                ChannelCategory channelCategory = new ChannelCategory();
                channelCategory.setMyconnector(this);
                metaData = channelCategory.describeEntity(metaDataKey);
            } else {
                if (!category.equals("UserCategory")) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[GroupCategory, AllChannelCategory, ChannelCategory, UserCategory]" + ", but found [" + category + "] instead");
                UserCategory userCategory = new UserCategory();
                userCategory.setMyconnector(this);
                metaData = userCategory.describeEntity(metaDataKey);
            }
            metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
            return new DefaultResult((Object)metaData);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, MetaDataGeneratorUtils.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
        }
    }
}

