/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.generated.config;

import org.mule.config.MuleManifest;
import org.mule.modules.slack.oauth.SlackConnectorOAuthManager;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SlackConnectorSlackOAuth2ConfigConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(SlackConnectorSlackOAuth2ConfigConfigDefinitionParser.class);

    public String moduleName() {
        return "Slack";
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Element oauthStoreConfigElement;
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, SlackConnectorOAuthManager.class);
        this.setDestroyMethodIfNeeded(builder, SlackConnectorOAuthManager.class);
        this.parseProperty(builder, element, "name", "name");
        this.parseProperty(builder, element, "authorizationUrl");
        this.parseProperty(builder, element, "accessTokenUrl");
        this.parseProperty(builder, element, "onNoToken");
        Element oauthHttpCallbackConfigElement = DomUtils.getChildElementByTagName((Element)element, (String)"oauth-callback-config");
        if (oauthHttpCallbackConfigElement != null) {
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "domain");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "localPort");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "remotePort");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "async");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "path");
            this.parseProperty(builder, oauthHttpCallbackConfigElement, "defaultAccessTokenId");
            if (this.hasAttribute(oauthHttpCallbackConfigElement, "connector-ref")) {
                builder.addPropertyValue("connector", (Object)new RuntimeBeanReference(oauthHttpCallbackConfigElement.getAttribute("connector-ref")));
            }
        }
        if ((oauthStoreConfigElement = DomUtils.getChildElementByTagName((Element)element, (String)"oauth-store-config")) != null) {
            this.parsePropertyRef(builder, oauthStoreConfigElement, "objectStore-ref", "accessTokenObjectStore");
        }
        this.parseProperty(builder, element, "consumerKey", "consumerKey");
        this.parseProperty(builder, element, "consumerSecret", "consumerSecret");
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)SlackConnectorOAuthManager.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [oauth2-type] within the connector [slack] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [oauth2-type] within the connector [slack] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

