/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.shaded.internal.inject;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.shaded.core.Context;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.InjecteeImpl;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.shaded.internal.util.ReflectionHelper;

@Singleton
public class ContextInjectionResolver
implements InjectionResolver<Context> {
    @Inject
    private ServiceLocator serviceLocator;

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Type requiredType = injectee.getRequiredType();
        boolean isHk2Factory = ReflectionHelper.isSubClassOf(requiredType, Factory.class);
        Injectee newInjectee = isHk2Factory ? this.getInjectee(injectee, ReflectionHelper.getTypeArgument(requiredType, 0)) : injectee;
        ActiveDescriptor ad = this.serviceLocator.getInjecteeDescriptor(newInjectee);
        if (ad != null) {
            ServiceHandle handle = this.serviceLocator.getServiceHandle(ad, newInjectee);
            if (isHk2Factory) {
                return this.asFactory(handle);
            }
            return handle.getService();
        }
        return null;
    }

    private Factory asFactory(final ServiceHandle handle) {
        return new Factory(){

            public Object provide() {
                return handle.getService();
            }

            public void dispose(Object instance) {
            }
        };
    }

    private Injectee getInjectee(Injectee injectee, Type requiredType) {
        return new RequiredTypeOverridingInjectee(injectee, requiredType);
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }

    private static class RequiredTypeOverridingInjectee
    extends InjecteeImpl {
        private static final long serialVersionUID = -3740895548611880187L;

        private RequiredTypeOverridingInjectee(Injectee injectee, Type requiredType) {
            super(injectee);
            this.setRequiredType(requiredType);
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            this.bind(ContextInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Context>>(){}).in(Singleton.class);
        }
    }
}

