/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import com.google.gson.Gson;
import java.io.IOException;
import javax.websocket.DeploymentException;
import javax.ws.rs.shaded.client.WebTarget;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.resources.Auth;
import org.mule.modules.slack.client.resources.Channels;
import org.mule.modules.slack.client.resources.Chat;
import org.mule.modules.slack.client.resources.Files;
import org.mule.modules.slack.client.resources.Groups;
import org.mule.modules.slack.client.resources.IM;
import org.mule.modules.slack.client.resources.UserGroups;
import org.mule.modules.slack.client.resources.Users;
import org.mule.modules.slack.client.rtm.EventHandler;
import org.mule.modules.slack.client.rtm.SlackMessageHandler;

public class SlackClient {
    private static final Logger logger = Logger.getLogger(SlackClient.class);
    private SlackRequester slackRequester;
    private SlackMessageHandler slackMessageHandler;
    private String selfId;
    private String token;
    private Gson gson;
    public final Chat chat;
    public final Users users;
    public final UserGroups usergroups;
    public final Channels channels;
    public final Groups groups;
    public final Files files;
    public final Auth auth;
    public final IM im;

    public SlackClient(String token) {
        this.slackRequester = new SlackRequester(token);
        this.token = token;
        this.gson = new Gson();
        this.usergroups = new UserGroups(this.slackRequester, this.gson);
        this.channels = new Channels(this.slackRequester, this.gson);
        this.users = new Users(this.slackRequester, this.gson);
        this.groups = new Groups(this.slackRequester, this.gson);
        this.chat = new Chat(this.slackRequester, this.gson);
        this.auth = new Auth(this.slackRequester);
        this.im = new IM(this.slackRequester, this.gson);
        this.files = new Files(this.slackRequester, this.gson);
    }

    public String getWebSockerURI() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("rtm.start");
        String s = SlackRequester.sendRequest(webTarget);
        this.selfId = new JSONObject(s).getJSONObject("self").getString("id");
        return new JSONObject(s).getString("url");
    }

    public void startRealTimeCommunication(EventHandler messageHandler) throws DeploymentException, InterruptedException, IOException {
        this.slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI());
        this.slackMessageHandler.messageHandler = messageHandler;
        while (true) {
            try {
                while (true) {
                    this.slackMessageHandler.connect();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error Cause: ", (Throwable)e);
                logger.warn((Object)"Retrying RTM Communication in 20 Seconds");
                Thread.sleep(20000L);
                logger.warn((Object)"Starting RTM Communication");
                this.slackMessageHandler = new SlackMessageHandler(this.getWebSockerURI());
                this.slackMessageHandler.messageHandler = messageHandler;
                continue;
            }
            break;
        }
    }

    public SlackMessageHandler getSlackMessageHandler() {
        return this.slackMessageHandler;
    }

    private String getURL(String operation) {
        return "https://slack.com/api/" + operation + "?token=" + this.token;
    }
}

