/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.shaded.client.WebTarget;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;
import org.mule.modules.slack.client.model.im.DirectMessageChannelCreationResponse;

public class IM {
    private final Type channelListType = new TypeToken<List<DirectMessageChannel>>(){}.getType();
    private final SlackRequester slackRequester;
    private final Gson gson;

    public IM(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public DirectMessageChannelCreationResponse openDirectMessageChannel(String userId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.open").queryParam("user", userId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (DirectMessageChannelCreationResponse)this.gson.fromJson(slackResponse.toString(), DirectMessageChannelCreationResponse.class);
    }

    public List<DirectMessageChannel> getDirectMessageChannelsList() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("ims");
        return (List)this.gson.fromJson(slackResponse.toString(), this.channelListType);
    }

    public List<Message> getDirectChannelHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "im.history");
    }

    public Boolean markViewDirectMessageChannel(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean closeDirectMessageChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("im.close").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path(operation).queryParam("channel", channelId).queryParam("latest", latest).queryParam("oldest", oldest).queryParam("count", count);
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.gson.fromJson(slackResponse.toString(), listType);
    }
}

