/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.utils.Tuple;
import org.mule.modules.slack.storage.SlackStorage;

public class ObjectStoreStorage
implements SlackStorage {
    private final ObjectStore<Serializable> objectStore;

    public ObjectStoreStorage(ObjectStore<Serializable> objectStore) {
        this.objectStore = objectStore;
    }

    public ObjectStoreStorage(MuleContext muleContext) {
        this.objectStore = (ObjectStore)muleContext.getRegistry().lookupObject("_defaultUserObjectStore");
        if (this.objectStore == null) {
            throw new SlackException("Unable to find an ObjectStore");
        }
    }

    @Override
    public List<Tuple<String, Object>> restoreFlowVars(String id) {
        ArrayList<Tuple<String, Object>> flowVars;
        try {
            flowVars = (ArrayList<Tuple<String, Object>>)this.objectStore.retrieve((Serializable)((Object)id));
        }
        catch (ObjectStoreException e) {
            flowVars = new ArrayList<Tuple<String, Object>>();
        }
        return flowVars;
    }

    @Override
    public void storageFlowVars(String id, List<Tuple<String, Object>> flowVars) {
        try {
            try {
                this.objectStore.store((Serializable)((Object)id), (Serializable)((Object)flowVars));
            }
            catch (ObjectStoreException e) {
                this.objectStore.remove((Serializable)((Object)id));
                this.objectStore.store((Serializable)((Object)id), (Serializable)((Object)flowVars));
            }
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }
}

