/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.shaded.client.WebTarget;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.group.Group;

public class Groups {
    private final Type groupsListType = new TypeToken<List<Group>>(){}.getType();
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Groups(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public List<Message> getGroupHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "groups.history");
    }

    public List<Group> getGroupList() {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("groups");
        return (List)this.gson.fromJson(slackResponse.toString(), this.groupsListType);
    }

    public Group createGroup(String name) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.create").queryParam("name", name);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public Boolean openGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.open").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean leaveGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.leave").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.archive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.setPurpose").queryParam("channel", channelID).queryParam("purpose", purpose);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.setTopic").queryParam("channel", channelID).queryParam("topic", topic);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean closeGroup(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.close").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewGroup(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromGroup(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.kick").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToGroup(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.invite").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveGroup(String groupID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.unarchive").queryParam("channel", groupID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Group renameGroup(String channelId, String newName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.rename").queryParam("channel", channelId).queryParam("name", newName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public Group getGroupInfo(String groupId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("groups.info").queryParam("channel", groupId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("group");
        return (Group)this.gson.fromJson(slackResponse.toString(), Group.class);
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path(operation).queryParam("channel", channelId).queryParam("latest", latest).queryParam("oldest", oldest).queryParam("count", count);
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.gson.fromJson(slackResponse.toString(), listType);
    }
}

