/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.websocket.DeploymentException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.callback.SourceCallback;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.model.User;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.chat.MessageResponse;
import org.mule.modules.slack.client.model.chat.attachment.ChatAttachment;
import org.mule.modules.slack.client.model.file.FileUploadResponse;
import org.mule.modules.slack.client.model.group.Group;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;
import org.mule.modules.slack.client.model.im.DirectMessageChannelCreationResponse;
import org.mule.modules.slack.client.model.usergroups.Usergroup;
import org.mule.modules.slack.client.rtm.ConfigurableHandler;
import org.mule.modules.slack.client.rtm.filter.AllEventNotifier;
import org.mule.modules.slack.client.rtm.filter.EventFilter;
import org.mule.modules.slack.client.rtm.filter.EventNotifier;
import org.mule.modules.slack.client.rtm.filter.MessagesNotifier;
import org.mule.modules.slack.client.rtm.filter.OnlyTypeNotifier;
import org.mule.modules.slack.client.rtm.filter.SelfEventsFilter;
import org.mule.modules.slack.config.SlackConfig;
import org.mule.modules.slack.config.SlackOAuth2Config;

public class SlackConnector {
    private static final Logger logger = Logger.getLogger(SlackConnector.class);
    private static final String NUMBER_OF_MESSAGES = "Number of messages to return, the value should be between 1 and 1000.";
    private static final String USER_TYPING_EVENT = "user_typing";
    private static final String IM_CREATED = "im_created";
    private static final String FILE_CREATED = "file_created";
    private static final String FILE_SHARED = "file_shared";
    private static final String FILE_PUBLIC = "file_public";
    @Inject
    private MuleContext muleContext;
    private SlackConfig slackConfig;

    public User getUserInfo(String id) {
        return this.slack().users.getUserInfo(id);
    }

    public User getUserInfoByName(String username, String path) {
        return this.slack().users.getUserInfoByName(username);
    }

    public List<User> getUserList() {
        return this.slack().users.getUserList();
    }

    public List<Channel> getChannelList() {
        return this.slack().channels.getChannelList();
    }

    public List<Message> getChannelHistory(String channelId, String latestTimestamp, String oldestTimestamp, String amountOfMessages) {
        return this.slack().channels.getChannelHistory(channelId, latestTimestamp, oldestTimestamp, amountOfMessages);
    }

    public Channel getChannelInfo(String channelId) {
        return this.slack().channels.getChannelById(channelId);
    }

    public Channel getChannelByName(String channelName) {
        return this.slack().channels.getChannelByName(channelName);
    }

    public Channel createChannel(String channelName) {
        return this.slack().channels.createChannel(channelName);
    }

    public Channel renameChannel(String channelId, String channelName) {
        return this.slack().channels.renameChannel(channelId, channelName);
    }

    public Channel joinChannel(String channelName) {
        return this.slack().channels.joinChannel(channelName);
    }

    public Boolean leaveChannel(String channelId) {
        return this.slack().channels.leaveChannel(channelId);
    }

    public Boolean archiveChannel(String channelID) {
        return this.slack().channels.archiveChannel(channelID);
    }

    public Boolean unarchiveChannel(String channelID) {
        return this.slack().channels.unarchiveChannel(channelID);
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        return this.slack().channels.setChannelTopic(channelID, topic);
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        return this.slack().channels.setChannelPurpose(channelID, purpose);
    }

    public MessageResponse postMessage(String message, String channelId, String username, String iconURL, Boolean asUser) {
        return this.slack().chat.sendMessage(message, channelId, username, iconURL, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public MessageResponse postMessageWithAttachment(String message, String channelId, String username, String iconURL, List<ChatAttachment> chatAttachmentList, Boolean asUser) {
        return this.slack().chat.sendMessageWithAttachment(message, channelId, username, iconURL, chatAttachmentList, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        return this.slack().chat.deleteMessage(timeStamp, channelId);
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        return this.slack().chat.updateMessage(timeStamp, channelId, message);
    }

    public DirectMessageChannelCreationResponse openDirectMessageChannel(String userId) {
        return this.slack().im.openDirectMessageChannel(userId);
    }

    public Boolean closeDirectMessageChannel(String channelId) {
        return this.slack().im.closeDirectMessageChannel(channelId);
    }

    public List<DirectMessageChannel> listDirectMessageChannels() {
        return this.slack().im.getDirectMessageChannelsList();
    }

    public List<Message> getDMHistory(String channelID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().im.getDirectChannelHistory(channelID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public List<Group> getGroupList() {
        return this.slack().groups.getGroupList();
    }

    public List<Message> getGroupHistory(String groupID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().groups.getGroupHistory(groupID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        return this.slack().groups.setGroupTopic(channelID, topic);
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        return this.slack().groups.setGroupPurpose(channelID, purpose);
    }

    public Group createGroup(String groupName) {
        return this.slack().groups.createGroup(groupName);
    }

    public Boolean closeGroup(String channelID) {
        return this.slack().groups.closeGroup(channelID);
    }

    public Boolean openGroup(String channelID) {
        return this.slack().groups.openGroup(channelID);
    }

    public Boolean archiveGroup(String channelID) {
        return this.slack().groups.archiveGroup(channelID);
    }

    public Boolean unarchiveGroup(String channelID) {
        return this.slack().groups.unarchiveGroup(channelID);
    }

    public Group renameGroup(String groupId, String groupName) {
        return this.slack().groups.renameGroup(groupId, groupName);
    }

    public Group getGroupInfo(String channelId) {
        return this.slack().groups.getGroupInfo(channelId);
    }

    public Boolean leaveGroup(String channelId) {
        return this.slack().groups.leaveGroup(channelId);
    }

    public FileUploadResponse uploadFile(String channelID, String fileName, String fileType, String title, String initialComment, String filePath) throws IOException {
        return this.slack().files.sendFile(channelID, fileName, fileType, title, initialComment, filePath);
    }

    public FileUploadResponse uploadFileAsInputStreams(String channelID, String fileName, String fileType, String title, String initialComment, InputStream inputStream) throws IOException {
        return this.slack().files.sendFile(channelID, fileName, fileType, title, initialComment, inputStream);
    }

    public List<Usergroup> listUserGroups(Boolean includeDisabled, Boolean includeCount, Boolean includeUsers) {
        return this.slack().usergroups.listUserGroups(includeDisabled, includeCount, includeUsers);
    }

    public Usergroup enableUserGroup(String userGroupId, Boolean includeCount) {
        return this.slack().usergroups.enableUserGroup(userGroupId, includeCount);
    }

    public Usergroup disableUserGroup(String userGroupId, Boolean includeCount) {
        return this.slack().usergroups.disableUserGroup(userGroupId, includeCount);
    }

    public Usergroup createUserGroup(String userGroupName, String handle, String description, List<String> channels, Boolean includeCount) {
        return this.slack().usergroups.createUserGroup(userGroupName, handle, description, channels, includeCount);
    }

    public Usergroup updateUserGroup(String userGroupId, String userGroupName, String handle, String description, List<String> channels, Boolean includeCount) {
        return this.slack().usergroups.updateUserGroup(userGroupId, userGroupName, handle, description, channels, includeCount);
    }

    public List<String> listUsersFromUserGroup(String userGroupId, Boolean includeDisabled) {
        return this.slack().usergroups.listUsersFromUserGroup(userGroupId, includeDisabled);
    }

    public Usergroup updateUsersFromUserGroup(String userGroupId, List<String> users, Boolean includeCount) {
        return this.slack().usergroups.updateUsersFromUserGroup(userGroupId, users, includeCount);
    }

    public void retrieveEvents(SourceCallback sourceCallback, Boolean messages, Boolean userTyping, Boolean directMessages, Boolean onlyNewMessages, Boolean ignoreSelfEvents, Boolean imCreated, Boolean fileCreated, Boolean fileShared, Boolean filePublic, Boolean allEvents, String filterClassName, String notifierClassName) throws IOException, InterruptedException, DeploymentException {
        if (this.getSlackConfig() instanceof SlackOAuth2Config) {
            logger.error((Object)"Retrieve Events source doesn't work with OAuth 2 configuration, please use Token Config");
            logger.error((Object)"Shutting down Retrieving of Messages!");
            return;
        }
        ArrayList<EventNotifier> observerList = new ArrayList<EventNotifier>();
        ArrayList<EventFilter> eventFilterList = new ArrayList<EventFilter>();
        if (messages.booleanValue()) {
            observerList.add(new MessagesNotifier(directMessages, onlyNewMessages));
        }
        if (userTyping.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(USER_TYPING_EVENT));
        }
        if (imCreated.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(IM_CREATED));
        }
        if (fileCreated.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_CREATED));
        }
        if (fileShared.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_SHARED));
        }
        if (filePublic.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_PUBLIC));
        }
        if (allEvents.booleanValue()) {
            observerList.add(new AllEventNotifier());
        }
        if (StringUtils.isNotEmpty((String)filterClassName)) {
            eventFilterList.add(this.getFilterInstance(filterClassName));
        }
        if (StringUtils.isNotEmpty((String)notifierClassName)) {
            observerList.add(this.getNotifierInstance(notifierClassName));
        }
        if (ignoreSelfEvents.booleanValue()) {
            eventFilterList.add(new SelfEventsFilter(this.slack().auth.getSelfId()));
        }
        this.slack().startRealTimeCommunication(new ConfigurableHandler(sourceCallback, observerList, eventFilterList));
    }

    private EventFilter getFilterInstance(String className) {
        try {
            logger.info((Object)("Detected custom filter class: " + className));
            Class<?> aClass = Class.forName(className, true, this.getMuleContext().getExecutionClassLoader());
            return (EventFilter)aClass.newInstance();
        }
        catch (ClassCastException e) {
            String errorMessage = String.format("The configured class [%s] does not implements 'org.mule.modules.slack.client.rtm.filter.SlackEventFilter'", className);
            logger.error((Object)errorMessage);
            throw new SlackException(errorMessage);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading Custom filter class", (Throwable)e);
            throw new SlackException("Error loading Custom filter class", e);
        }
    }

    private EventNotifier getNotifierInstance(String className) {
        try {
            logger.info((Object)("Detected custom filter class: " + className));
            Class<?> aClass = Class.forName(className, true, this.getMuleContext().getExecutionClassLoader());
            return (EventNotifier)aClass.newInstance();
        }
        catch (ClassCastException e) {
            String errorMessage = String.format("The configured class [%s] does not implements 'org.mule.modules.slack.client.rtm.filter.EventObserver'", className);
            logger.error((Object)errorMessage);
            throw new SlackException(errorMessage);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading Custom filter class", (Throwable)e);
            throw new SlackException("Error loading Custom filter class", e);
        }
    }

    public SlackClient slack() {
        return this.slackConfig.getSlackClient();
    }

    public SlackConfig getSlackConfig() {
        return this.slackConfig;
    }

    public void setSlackConfig(SlackConfig slackConfig) {
        this.slackConfig = slackConfig;
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

