/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import java.util.List;
import javax.ws.rs.shaded.client.WebTarget;
import org.glassfish.jersey.shaded.uri.UriComponent;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.chat.MessageResponse;
import org.mule.modules.slack.client.model.chat.attachment.ChatAttachment;

public class Chat {
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Chat(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public MessageResponse sendMessage(String message, String channelId, String username, String iconUrl, Boolean asUser) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.postMessage").queryParam("channel", channelId).queryParam("text", UriComponent.encode(message, UriComponent.Type.QUERY_PARAM_SPACE_ENCODED)).queryParam("username", username).queryParam("icon_url", iconUrl).queryParam("as_user", String.valueOf(asUser));
        String output = SlackRequester.sendRequest(webTarget);
        return (MessageResponse)this.gson.fromJson(output, MessageResponse.class);
    }

    public MessageResponse sendMessageWithAttachment(String message, String channelId, String username, String iconUrl, List<ChatAttachment> chatAttachmentArrayList, Boolean asUser) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.postMessage").queryParam("channel", channelId).queryParam("text", message).queryParam("username", username).queryParam("icon_url", iconUrl).queryParam("as_user", String.valueOf(asUser));
        webTarget = webTarget.queryParam("attachments", UriComponent.encode(this.gson.toJson(chatAttachmentArrayList), UriComponent.Type.QUERY_PARAM_SPACE_ENCODED));
        String output = SlackRequester.sendRequest(webTarget);
        return (MessageResponse)this.gson.fromJson(output, MessageResponse.class);
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.delete").queryParam("channel", channelId).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("chat.update").queryParam("channel", channelId).queryParam("text", message).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }
}

