/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.shaded.client.WebTarget;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.model.usergroups.Usergroup;

public class UserGroups {
    private static final String USERGROUP = "usergroup";
    private static final String INCLUDE_DISABLED = "include_disabled";
    private static final String INCLUDE_COUNT = "include_count";
    private static final String INCLUDE_USERS = "include_users";
    private static final String NAME = "name";
    private static final String HANDLE = "handle";
    private static final String DESCRIPTION = "description";
    private static final String CHANNELS = "channels";
    private static final String USERS = "users";
    private final SlackRequester slackRequester;
    private final Gson gson;
    private final Type userGroupsListType = new TypeToken<ArrayList<Usergroup>>(){}.getType();
    private final Type stringListType = new TypeToken<List<String>>(){}.getType();

    public UserGroups(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public List<Usergroup> listUserGroups(boolean includeDisabled, boolean includeCount, boolean includeUsers) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.list").queryParam(INCLUDE_DISABLED, includeDisabled ? 1 : 0).queryParam(INCLUDE_COUNT, includeCount ? 1 : 0).queryParam(INCLUDE_USERS, includeUsers ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("usergroups");
        return (List)this.gson.fromJson(slackResponse.toString(), this.userGroupsListType);
    }

    public Usergroup enableUserGroup(String usergroupId, boolean includeCount) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.enable").queryParam(USERGROUP, usergroupId).queryParam(INCLUDE_COUNT, includeCount ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERGROUP);
        return (Usergroup)this.gson.fromJson(slackResponse.toString(), Usergroup.class);
    }

    public Usergroup disableUserGroup(String usergroupId, boolean includeCount) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.disable").queryParam(USERGROUP, usergroupId).queryParam(INCLUDE_COUNT, includeCount ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERGROUP);
        return (Usergroup)this.gson.fromJson(slackResponse.toString(), Usergroup.class);
    }

    public Usergroup createUserGroup(String name, String handle, String description, List<String> channels, boolean include_count) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.create").queryParam(NAME, name).queryParam(HANDLE, handle).queryParam(DESCRIPTION, description).queryParam(CHANNELS, StringUtils.join(channels, (char)',')).queryParam(INCLUDE_COUNT, include_count ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERGROUP);
        return (Usergroup)this.gson.fromJson(slackResponse.toString(), Usergroup.class);
    }

    public Usergroup updateUserGroup(String usergroupId, String name, String handle, String description, List<String> channels, boolean include_count) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.update").queryParam(USERGROUP, usergroupId).queryParam(NAME, name).queryParam(HANDLE, handle).queryParam(DESCRIPTION, description).queryParam(CHANNELS, StringUtils.join(channels, (char)',')).queryParam(INCLUDE_COUNT, include_count ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERGROUP);
        return (Usergroup)this.gson.fromJson(slackResponse.toString(), Usergroup.class);
    }

    public List<String> listUsersFromUserGroup(String usergroupId, boolean includeDisabled) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.user.list").queryParam(USERGROUP, usergroupId).queryParam(INCLUDE_DISABLED, includeDisabled ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERS);
        return (List)this.gson.fromJson(slackResponse.toString(), this.stringListType);
    }

    public Usergroup updateUsersFromUserGroup(String usergroupId, List<String> users, boolean includeCount) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("usergroups.user.update").queryParam(USERGROUP, usergroupId).queryParam(USERS, StringUtils.join(users, (char)',')).queryParam(INCLUDE_COUNT, includeCount ? 1 : 0);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get(USERGROUP);
        return (Usergroup)this.gson.fromJson(slackResponse.toString(), Usergroup.class);
    }
}

