/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.rtm;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.api.callback.SourceCallback;
import org.mule.modules.slack.client.rtm.EventHandler;
import org.mule.modules.slack.client.rtm.filter.EventFilter;
import org.mule.modules.slack.client.rtm.filter.EventNotifier;

public class ConfigurableHandler
implements EventHandler {
    private static final Logger logger = Logger.getLogger(ConfigurableHandler.class);
    private SourceCallback sourceCallback;
    private Gson gson;
    private Type type = new TypeToken<Map<String, Object>>(){}.getType();
    private List<EventNotifier> observerList;
    private List<EventFilter> eventFilterList;

    public ConfigurableHandler(SourceCallback sourceCallback, List<EventNotifier> eventNotifierList, List<EventFilter> eventFilterList) {
        this.sourceCallback = sourceCallback;
        this.gson = new Gson();
        this.observerList = eventNotifierList;
        this.eventFilterList = eventFilterList;
    }

    @Override
    public void onMessage(String message) {
        Map messageMap = (Map)this.gson.fromJson(message, this.type);
        if (this.shouldBeAccepted(messageMap, this.eventFilterList) && this.shouldBeSent(messageMap, this.observerList)) {
            try {
                this.sourceCallback.process((Object)messageMap);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private boolean shouldBeAccepted(Map<String, Object> message, List<EventFilter> filterList) {
        for (EventFilter eventFilter : filterList) {
            if (eventFilter.shouldAccept(message)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldBeSent(Map<String, Object> message, List<EventNotifier> observerList) {
        for (EventNotifier eventNotifier : observerList) {
            if (!eventNotifier.shouldSend(message)) continue;
            return true;
        }
        return false;
    }
}

