/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.shaded.media.multipart;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.ParseException;
import javax.ws.rs.shaded.ProcessingException;
import javax.ws.rs.shaded.core.MediaType;
import javax.ws.rs.shaded.core.MultivaluedMap;
import javax.ws.rs.shaded.ext.MessageBodyReader;
import javax.ws.rs.shaded.ext.Providers;
import org.glassfish.jersey.shaded.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.shaded.media.multipart.BodyPartEntity;
import org.glassfish.jersey.shaded.media.multipart.ContentDisposition;
import org.glassfish.jersey.shaded.media.multipart.MultiPart;
import org.glassfish.jersey.shaded.media.multipart.ParameterizedHeadersMap;
import org.glassfish.jersey.shaded.media.multipart.internal.LocalizationMessages;
import org.glassfish.jersey.shaded.message.MessageBodyWorkers;
import org.glassfish.jersey.shaded.message.internal.HeaderUtils;
import org.glassfish.jersey.shaded.message.internal.ParameterizedHeader;

public class BodyPart {
    protected ContentDisposition contentDisposition = null;
    private Object entity;
    private MultivaluedMap<String, String> headers = HeaderUtils.createInbound();
    private MediaType mediaType = null;
    public MessageBodyWorkers messageBodyWorkers;
    private MultiPart parent = null;
    private Providers providers = null;

    public BodyPart() {
        this(MediaType.TEXT_PLAIN_TYPE);
    }

    public BodyPart(MediaType mediaType) {
        this.setMediaType(mediaType);
    }

    public BodyPart(Object entity, MediaType mediaType) {
        this.setEntity(entity);
        this.setMediaType(mediaType);
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, ParameterizedHeader> getParameterizedHeaders() throws ParseException {
        return new ImmutableMultivaluedMap<String, ParameterizedHeader>(new ParameterizedHeadersMap(this.headers));
    }

    public ContentDisposition getContentDisposition() {
        String scd;
        if (this.contentDisposition == null && (scd = this.headers.getFirst("Content-Disposition")) != null) {
            try {
                this.contentDisposition = new ContentDisposition(scd);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Error parsing content disposition: " + scd, ex);
            }
        }
        return this.contentDisposition;
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
        this.headers.remove("Content-Disposition");
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            throw new IllegalArgumentException("mediaType cannot be null");
        }
        this.mediaType = mediaType;
    }

    public MultiPart getParent() {
        return this.parent;
    }

    public void setParent(MultiPart parent) {
        this.parent = parent;
    }

    public Providers getProviders() {
        return this.providers;
    }

    public void setProviders(Providers providers) {
        this.providers = providers;
    }

    public void cleanup() {
        if (this.getEntity() != null && this.getEntity() instanceof BodyPartEntity) {
            ((BodyPartEntity)this.getEntity()).cleanup();
        }
    }

    public BodyPart entity(Object entity) {
        this.setEntity(entity);
        return this;
    }

    public <T> T getEntityAs(Class<T> clazz) {
        if (this.entity == null || !(this.entity instanceof BodyPartEntity)) {
            throw new IllegalStateException(LocalizationMessages.ENTITY_HAS_WRONG_TYPE());
        }
        Annotation[] annotations = new Annotation[0];
        MessageBodyReader<T> reader = this.messageBodyWorkers.getMessageBodyReader(clazz, clazz, annotations, this.mediaType);
        if (reader == null) {
            throw new IllegalArgumentException(LocalizationMessages.NO_AVAILABLE_MBR(clazz, this.mediaType));
        }
        try {
            return reader.readFrom(clazz, clazz, annotations, this.mediaType, this.headers, ((BodyPartEntity)this.entity).getInputStream());
        }
        catch (IOException ioe) {
            throw new ProcessingException(LocalizationMessages.ERROR_READING_ENTITY(String.class), ioe);
        }
    }

    public BodyPart type(MediaType type) {
        this.setMediaType(type);
        return this;
    }

    public BodyPart contentDisposition(ContentDisposition contentDisposition) {
        this.setContentDisposition(contentDisposition);
        return this;
    }

    public void setMessageBodyWorkers(MessageBodyWorkers messageBodyWorkers) {
        this.messageBodyWorkers = messageBodyWorkers;
    }
}

