/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.config;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.config.SlackConfig;

public class SlackTokenConfig
implements SlackConfig {
    private SlackClient slackClient;
    private String accessToken;

    public void connect(String accessToken) throws ConnectionException {
        this.slackClient = new SlackClient(accessToken);
        if (!this.slackClient.auth.isConnected().booleanValue()) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "Invalid Token", "Invalid Token");
        }
    }

    public void disconnect() {
        this.slackClient = null;
    }

    public boolean isValid() {
        return this.slackClient != null && this.slackClient.auth.isConnected() != false;
    }

    public String getConnectionIdentifier() {
        return this.accessToken;
    }

    @Override
    public SlackClient getSlackClient() {
        return this.slackClient;
    }

    @Override
    public String getToken() {
        return this.accessToken;
    }

    public void setToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.slackClient = new SlackClient(accessToken);
        this.accessToken = accessToken;
    }

    @Override
    public Boolean isAuthorized() {
        return this.accessToken != null;
    }
}

