/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.resources;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.shaded.client.WebTarget;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.modules.slack.client.SlackRequester;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;

public class Channels {
    private final SlackRequester slackRequester;
    private final Gson gson;

    public Channels(SlackRequester slackRequester, Gson gson) {
        this.slackRequester = slackRequester;
        this.gson = gson;
    }

    public List<Channel> getChannelList() {
        ArrayList<Channel> list = new ArrayList<Channel>();
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.list");
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray channels = (JSONArray)new JSONObject(output).get("channels");
        for (int i = 0; i < channels.length(); ++i) {
            JSONObject channel = (JSONObject)channels.get(i);
            Channel newChannel = (Channel)this.gson.fromJson(channel.toString(), Channel.class);
            list.add(newChannel);
        }
        return list;
    }

    public Boolean leaveChannel(String channelId) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.leave").queryParam("channel", channelId);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Channel getChannelById(String id) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.info").queryParam("channel", id);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public List<Message> getChannelHistory(String channelId, String latest, String oldest, String count) {
        return this.getMessages(channelId, latest, oldest, count, "channels.history");
    }

    public Channel createChannel(String channelName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.create").queryParam("name", channelName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel renameChannel(String channelId, String newName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.rename").queryParam("name", newName).queryParam("channel", channelId);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel joinChannel(String channelName) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.join").queryParam("name", channelName);
        String output = SlackRequester.sendRequest(webTarget);
        JSONObject slackResponse = (JSONObject)new JSONObject(output).get("channel");
        return (Channel)this.gson.fromJson(slackResponse.toString(), Channel.class);
    }

    public Channel getChannelByName(String name) {
        List<Channel> list = this.getChannelList();
        for (Channel channel : list) {
            if (!channel.getName().equals(name)) continue;
            return channel;
        }
        throw new SlackException("Channel: " + name + " does not exist.");
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.setPurpose").queryParam("channel", channelID).queryParam("purpose", purpose);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.setTopic").queryParam("channel", channelID).queryParam("topic", topic);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean markViewChannel(String channelID, String timeStamp) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.mark").queryParam("channel", channelID).queryParam("ts", timeStamp);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean kickUserFromChannel(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.kick").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean inviteUserToChannel(String channelID, String user) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.invite").queryParam("channel", channelID).queryParam("user", user);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean unarchiveChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.unarchive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public Boolean archiveChannel(String channelID) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path("channels.archive").queryParam("channel", channelID);
        String output = SlackRequester.sendRequest(webTarget);
        return new JSONObject(output).getBoolean("ok");
    }

    public List<Message> getMessages(String channelId, String latest, String oldest, String count, String operation) {
        WebTarget webTarget = this.slackRequester.getWebTarget().path(operation).queryParam("channel", channelId).queryParam("latest", latest).queryParam("oldest", oldest).queryParam("count", count);
        String output = SlackRequester.sendRequest(webTarget);
        JSONArray slackResponse = (JSONArray)new JSONObject(output).get("messages");
        Type listType = new TypeToken<ArrayList<Message>>(){}.getType();
        return (List)this.gson.fromJson(slackResponse.toString(), listType);
    }
}

