/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.shaded.client;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.shaded.ext.ReaderInterceptor;
import javax.ws.rs.shaded.ext.WriterInterceptor;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.collect.Lists;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.shaded.client.ClientRequest;
import org.glassfish.jersey.shaded.internal.inject.Providers;
import org.glassfish.jersey.shaded.internal.util.collection.Ref;
import org.glassfish.jersey.shaded.message.MessageBodyWorkers;
import org.glassfish.jersey.shaded.model.internal.RankedComparator;

public class RequestProcessingInitializationStage
implements Function<ClientRequest, ClientRequest> {
    private final Provider<Ref<ClientRequest>> requestRefProvider;
    private final Provider<MessageBodyWorkers> workersProvider;
    private final Iterable<WriterInterceptor> writerInterceptors;
    private final Iterable<ReaderInterceptor> readerInterceptors;

    @Inject
    public RequestProcessingInitializationStage(Provider<Ref<ClientRequest>> requestRefProvider, Provider<MessageBodyWorkers> workersProvider, ServiceLocator locator) {
        this.requestRefProvider = requestRefProvider;
        this.workersProvider = workersProvider;
        this.writerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, WriterInterceptor.class, new RankedComparator())));
        this.readerInterceptors = Collections.unmodifiableList(Lists.newArrayList(Providers.getAllProviders(locator, ReaderInterceptor.class, new RankedComparator())));
    }

    public ClientRequest apply(ClientRequest requestContext) {
        ((Ref)this.requestRefProvider.get()).set(requestContext);
        requestContext.setWorkers((MessageBodyWorkers)this.workersProvider.get());
        requestContext.setWriterInterceptors(this.writerInterceptors);
        requestContext.setReaderInterceptors(this.readerInterceptors);
        return requestContext;
    }
}

