/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JoinBuilder {
    private String expression;
    private String as;
    private String on;
    private boolean async = true;
    private int threads = 10;
    private Executor executor;

    public static JoinBuilder expression(String expression, String as) {
        return new JoinBuilder().expression(expression).as(as);
    }

    public String getExpression() {
        return this.expression;
    }

    public JoinBuilder expression(String expression) {
        this.expression = expression;
        return this;
    }

    public String getAs() {
        return this.as;
    }

    public JoinBuilder as(String as) {
        this.as = as;
        return this;
    }

    public String getOn() {
        return this.on;
    }

    public JoinBuilder on(String on) {
        this.on = on;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public JoinBuilder async() {
        this.async = true;
        return this;
    }

    public JoinBuilder sync() {
        this.async = false;
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    public JoinBuilder threads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("Thread count for an async join can not be less than one.");
        }
        this.threads = threads;
        return this;
    }

    public JoinBuilder executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Executor getExecutor() {
        if (this.executor == null && this.async) {
            this.executor = new ThreadPoolExecutor(this.threads, this.threads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return this.executor;
    }
}

