/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql;

import com.mulesoft.mql.JoinBuilder;
import com.mulesoft.mql.LazyQueryContext;
import com.mulesoft.mql.ObjectBuilder;
import com.mulesoft.mql.QueryBuilder;
import com.mulesoft.mql.QueryException;
import com.mulesoft.mql.grammar.lexer.Lexer;
import com.mulesoft.mql.grammar.lexer.LexerException;
import com.mulesoft.mql.grammar.node.Start;
import com.mulesoft.mql.grammar.parser.Parser;
import com.mulesoft.mql.grammar.parser.ParserException;
import com.mulesoft.mql.impl.JoinPredicate;
import com.mulesoft.mql.impl.MqlInterpreter;
import com.mulesoft.mql.impl.OrderByComparator;
import com.mulesoft.mql.impl.SelectEvaluator;
import com.mulesoft.mql.impl.WherePredicate;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private final QueryBuilder queryBuilder;
    private Predicate joinPredicate;
    private Predicate wherePredicate;
    private JoinBuilder joinBuilder;
    private String defaultFromObject = "items";
    private Serializable compiledFromExpression;
    private SelectEvaluator selectEvaluator;

    public Query(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        ObjectBuilder select = queryBuilder.getSelect();
        if (select != null) {
            this.selectEvaluator = new SelectEvaluator(queryBuilder, select);
        }
        this.joinBuilder = queryBuilder.getJoin();
        this.joinPredicate = this.getJoin();
        this.wherePredicate = this.getWhere();
    }

    public static Query create(String queryString) {
        Lexer lexer = new Lexer(new PushbackReader(new StringReader(queryString)));
        Parser parser = new Parser(lexer);
        try {
            Start ast = parser.parse();
            MqlInterpreter interpreter = new MqlInterpreter();
            ast.apply(interpreter);
            return interpreter.getQuery();
        }
        catch (ParserException e) {
            throw new QueryException(e);
        }
        catch (LexerException e) {
            throw new QueryException(e);
        }
        catch (IOException e) {
            throw new QueryException(e);
        }
    }

    public static <T> T execute(String queryString, Collection<?> items) {
        return Query.create(queryString).execute(items);
    }

    public static <T> T execute(String queryString, Map<String, Object> context) {
        return Query.create(queryString).execute(context);
    }

    public <T> T execute(Collection<?> items) {
        return this.execute(items, this.getDefaultSelectObject());
    }

    public <T> T execute(Collection<?> items, String as) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(as, items);
        return this.execute(context);
    }

    public <T> T execute(final Map<String, Object> context) {
        List<Object> items;
        Object from = this.getFrom(context);
        boolean selectSingleObject = false;
        if (from instanceof Collection) {
            items = (List<Object>)from;
        } else if (from.getClass().isArray()) {
            items = Arrays.asList((Object[])from);
        } else {
            items = Arrays.asList(from);
            selectSingleObject = true;
        }
        ArrayList<Map<String, Object>> itemsAsMaps = new ArrayList<Map<String, Object>>();
        for (Object e : items) {
            if (e == null) {
                throw new IllegalStateException("null items are not allowed in the list of queryable objects.");
            }
            LazyQueryContext vars = new LazyQueryContext(){

                public Object load(String key) {
                    return context.get(key);
                }
            };
            vars.putAll(context);
            vars.put(this.queryBuilder.getAs(), e);
            itemsAsMaps.add(vars);
        }
        List resultList = new ArrayList();
        resultList = this.joinAndFilter(itemsAsMaps, resultList);
        resultList = this.doSelect(resultList);
        this.order(resultList);
        if (selectSingleObject) {
            return resultList.size() > 0 ? (T)resultList.get(0) : null;
        }
        return (T)resultList;
    }

    protected Object getFrom(Map<String, Object> context) {
        if (this.compiledFromExpression == null) {
            String fromObjectName = this.queryBuilder.getFrom();
            if (fromObjectName == null) {
                fromObjectName = this.getDefaultSelectObject();
            }
            this.compiledFromExpression = MVEL.compileExpression((String)fromObjectName);
        }
        return MVEL.executeExpression((Object)this.compiledFromExpression, context);
    }

    protected void order(List resultList) {
        if (this.queryBuilder.getOrderBy() != null) {
            Collections.sort(resultList, new OrderByComparator(this.queryBuilder));
        }
    }

    protected List joinAndFilter(List<Map<String, Object>> itemsAsMaps, List resultList) {
        Predicate predicate = AndPredicate.getInstance((Predicate)this.joinPredicate, (Predicate)this.wherePredicate);
        if (this.joinBuilder != null && this.joinBuilder.isAsync() && itemsAsMaps.size() > 1) {
            return this.doAsyncJoinAndFilter(itemsAsMaps, resultList, predicate);
        }
        this.doSyncJoinAndFilter(itemsAsMaps, resultList, predicate);
        return resultList;
    }

    protected void doSyncJoinAndFilter(List<Map<String, Object>> itemsAsMaps, List resultList, Predicate predicate) {
        for (int i = 0; i < itemsAsMaps.size() && i < this.queryBuilder.getMax(); ++i) {
            Map<String, Object> object = itemsAsMaps.get(i);
            if (!predicate.evaluate(object)) continue;
            resultList.add(object);
        }
    }

    protected List doAsyncJoinAndFilter(List<Map<String, Object>> itemsAsMaps, List resultList, Predicate predicate) {
        Executor executor = this.joinBuilder.getExecutor();
        List syncedList = Collections.synchronizedList(resultList);
        CountDownLatch latch = new CountDownLatch(itemsAsMaps.size());
        for (int i = 0; i < itemsAsMaps.size(); ++i) {
            Map<String, Object> object = itemsAsMaps.get(i);
            executor.execute(new JoinAndFilterRunnable(object, predicate, syncedList, latch));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (int i = resultList.size(); i >= this.queryBuilder.getMax(); --i) {
            resultList.remove(this.queryBuilder.getMax());
        }
        return resultList;
    }

    protected List doSelect(List list) {
        ObjectBuilder select = this.queryBuilder.getSelect();
        if (select != null) {
            ArrayList<Object> transformedObjects = new ArrayList<Object>();
            for (Object e : list) {
                Map vars = (Map)e;
                transformedObjects.add(this.selectEvaluator.evaluate(vars));
            }
            list = transformedObjects;
        } else {
            for (int i = 0; i < list.size(); ++i) {
                Map object = (Map)list.get(i);
                list.set(i, object.get(this.queryBuilder.getAs()));
            }
        }
        return list;
    }

    protected Predicate getJoin() {
        Predicate joinPredicate = this.queryBuilder.getJoin() != null ? new JoinPredicate(this.queryBuilder) : TruePredicate.INSTANCE;
        return joinPredicate;
    }

    protected Predicate getWhere() {
        Predicate wherePredicate = this.queryBuilder.getRestriction() != null ? new WherePredicate(this.queryBuilder) : TruePredicate.INSTANCE;
        return wherePredicate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("from xxxx");
        if (this.queryBuilder.as != null) {
            builder.append(" as ").append(this.queryBuilder.as);
        }
        if (this.queryBuilder.getRestriction() != null) {
            builder.append(" where ").append(this.queryBuilder.getRestriction());
        }
        return builder.toString();
    }

    public String getDefaultSelectObject() {
        return this.defaultFromObject;
    }

    public void setDefaultSelectObject(String defaultFromObject) {
        this.defaultFromObject = defaultFromObject;
    }

    public void setExecutor(Executor executor) {
        this.joinBuilder.executor(executor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JoinAndFilterRunnable
    implements Runnable {
        private final Predicate predicate;
        private final Map<String, Object> object;
        private final List syncedList;
        private final CountDownLatch latch;

        private JoinAndFilterRunnable(Map<String, Object> object, Predicate predicate, List syncedList, CountDownLatch latch) {
            this.object = object;
            this.predicate = predicate;
            this.syncedList = syncedList;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.syncedList.size() >= Query.this.queryBuilder.getMax()) {
                    return;
                }
                if (this.predicate.evaluate(this.object)) {
                    this.syncedList.add(this.object);
                }
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

