/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql;

import com.mulesoft.mql.JoinBuilder;
import com.mulesoft.mql.ObjectBuilder;
import com.mulesoft.mql.Query;
import com.mulesoft.mql.Restriction;
import java.util.concurrent.Executor;

public class QueryBuilder {
    protected String from;
    protected String as = "item";
    protected String orderBy;
    protected int max = Integer.MAX_VALUE;
    protected ObjectBuilder select;
    private Restriction restriction;
    private JoinBuilder join;

    public QueryBuilder where(Restriction restriction) {
        this.restriction = restriction;
        return this;
    }

    public QueryBuilder from(String from) {
        this.from = from;
        return this;
    }

    public QueryBuilder as(String property) {
        this.as = property;
        return this;
    }

    public QueryBuilder orderby(String property) {
        this.orderBy = property;
        return this;
    }

    public QueryBuilder max(int max) {
        this.max = max;
        return this;
    }

    public QueryBuilder select(ObjectBuilder objectBuilder) {
        this.select = objectBuilder;
        return this;
    }

    public Query build() {
        return new Query(this);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getAs() {
        return this.as;
    }

    public int getMax() {
        return this.max;
    }

    public ObjectBuilder getSelect() {
        return this.select;
    }

    public Restriction getRestriction() {
        return this.restriction;
    }

    public String getFrom() {
        return this.from;
    }

    public QueryBuilder join(JoinBuilder join) {
        this.join = join;
        return this;
    }

    public QueryBuilder join(String expression, String as) {
        this.join = new JoinBuilder();
        this.join.expression(expression);
        this.join.as(as);
        return this;
    }

    public QueryBuilder joinAsync(String expression, String as) {
        return this.joinAsync(expression, as, 10);
    }

    public QueryBuilder joinAsync(String expression, String as, int threads) {
        this.join = JoinBuilder.expression(expression, as).async().threads(threads);
        return this;
    }

    public QueryBuilder joinAsync(String expression, String as, Executor executor) {
        this.join = new JoinBuilder().expression(expression).as(as).async().executor(executor);
        return this;
    }

    public JoinBuilder getJoin() {
        return this.join;
    }
}

