/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Restriction {
    private Object value;
    private Object left;
    private Operator operator;

    protected Restriction(Operator o, Object left, Object right) {
        this.operator = o;
        this.left = left;
        this.value = right;
    }

    protected Restriction(Operator not, Restriction restriction) {
        this.operator = not;
        this.value = restriction;
    }

    public Object getRight() {
        return this.value;
    }

    public Object getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        this.toString(sb, false);
    }

    private void toString(StringBuilder sb, boolean not) {
        switch (this.operator) {
            case EQUALS: {
                sb.append(this.left);
                if (not) {
                    sb.append(" != '");
                } else {
                    sb.append(" = '");
                }
                sb.append(this.value);
                sb.append("'");
                break;
            }
            case LIKE: {
                sb.append(this.left);
                if (not) {
                    sb.append(" not");
                }
                sb.append(" like '");
                sb.append(this.value);
                sb.append("'");
                break;
            }
            case IN: {
                sb.append(this.left);
                sb.append(" in ('");
                boolean first = true;
                for (Object val : (Collection)this.value) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(val).append("'");
                }
                sb.append(")");
                break;
            }
            case OR: {
                Restriction or1 = (Restriction)this.left;
                Restriction or2 = (Restriction)this.value;
                sb.append("(");
                or1.toString(sb);
                sb.append(" or ");
                or2.toString(sb);
                sb.append(")");
                break;
            }
            case AND: {
                Restriction and1 = (Restriction)this.left;
                Restriction and2 = (Restriction)this.value;
                sb.append("(");
                and1.toString(sb);
                sb.append(" and ");
                and2.toString(sb);
                sb.append(")");
                break;
            }
            case NOT: {
                ((Restriction)this.value).toString(sb, true);
            }
        }
    }

    public static Restriction eq(Object left, Object right) {
        return new Restriction(Operator.EQUALS, left, right);
    }

    public static Restriction gt(Object left, Object right) {
        return new Restriction(Operator.GT, left, right);
    }

    public static Restriction lt(Object left, Object right) {
        return new Restriction(Operator.LT, left, right);
    }

    public static Restriction gte(Object left, Object right) {
        return new Restriction(Operator.GTE, left, right);
    }

    public static Restriction lte(Object left, Object right) {
        return new Restriction(Operator.LTE, left, right);
    }

    public static Restriction not(Restriction restriction) {
        return new Restriction(Operator.NOT, restriction);
    }

    public static Restriction like(Object left, Object value) {
        return new Restriction(Operator.LIKE, left, value);
    }

    public static Restriction in(Object left, Collection<?> values) {
        return new Restriction(Operator.IN, left, values);
    }

    public static Restriction or(Restriction left, Restriction right) {
        return new Restriction(Operator.OR, left, right);
    }

    public static Restriction and(Restriction left, Restriction right) {
        return new Restriction(Operator.AND, left, right);
    }

    public static Property property(String name) {
        return new Property(name);
    }

    public static final class Property {
        private String name;

        public Property(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "property[" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        EQUALS,
        NOT,
        IN,
        LIKE,
        OR,
        AND,
        GT,
        LT,
        GTE,
        LTE;

    }
}

