/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql.impl;

import com.mulesoft.mql.QueryBuilder;
import com.mulesoft.mql.QueryException;
import com.mulesoft.mql.Restriction;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.mvel2.MVEL;

public class WherePredicate
implements Predicate {
    private final QueryBuilder queryBuilder;
    private Map<Restriction.Property, Serializable> compiledExpressions = new HashMap<Restriction.Property, Serializable>();

    public WherePredicate(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        Restriction restriction = queryBuilder.getRestriction();
        this.initializeExpressions(restriction);
    }

    private void initializeExpressions(Restriction restriction) {
        this.initializeExpression(restriction.getLeft());
        this.initializeExpression(restriction.getRight());
    }

    private void initializeExpression(Object o) {
        if (o instanceof Restriction) {
            this.initializeExpressions((Restriction)o);
            return;
        }
        if (!(o instanceof Restriction.Property)) {
            return;
        }
        String expression = ((Restriction.Property)o).getName();
        this.compiledExpressions.put((Restriction.Property)o, MVEL.compileExpression((String)expression));
    }

    public boolean evaluate(Object object) {
        Restriction r = this.queryBuilder.getRestriction();
        return this.evaluate(object, r);
    }

    private boolean evaluate(Object object, Restriction r) {
        switch (r.getOperator()) {
            case EQUALS: {
                return this.equals(object, r);
            }
            case NOT: {
                return !this.evaluate(object, (Restriction)r.getRight());
            }
            case OR: {
                return this.or(object, r);
            }
            case AND: {
                return this.and(object, r);
            }
            case GT: {
                return this.evaluateComparison(object, r) > 0;
            }
            case GTE: {
                return this.evaluateComparison(object, r) >= 0;
            }
            case LT: {
                return this.evaluateComparison(object, r) < 0;
            }
            case LTE: {
                return this.evaluateComparison(object, r) <= 0;
            }
            case LIKE: {
                return this.evaluateLike(object, r);
            }
        }
        return false;
    }

    private boolean evaluateLike(Object object, Restriction r) {
        if (r.getLeft() instanceof Restriction) {
            throw new QueryException("The left side of a like clause cannot be a restriction.");
        }
        if (r.getRight() instanceof Restriction) {
            throw new QueryException("The right side of a like clause cannot be a restriction.");
        }
        String left = this.evaluate(object, r.getLeft()).toString();
        String right = this.evaluate(object, r.getRight()).toString();
        return left.toLowerCase().contains(right.toLowerCase());
    }

    private boolean and(Object object, Restriction r) {
        Object left = r.getLeft();
        Object right = r.getRight();
        if (!(left instanceof Restriction)) {
            throw new QueryException(MessageFormat.format("Left statement of an 'and' restriction must be another restriction. Found {0} instead", left));
        }
        if (!(right instanceof Restriction)) {
            throw new QueryException(MessageFormat.format("Right statement of an 'and' restriction must be another restriction. Found {0} instead", right));
        }
        return this.evaluate(object, (Restriction)left) && this.evaluate(object, (Restriction)right);
    }

    private boolean or(Object object, Restriction r) {
        Object left = r.getLeft();
        Object right = r.getRight();
        if (!(left instanceof Restriction)) {
            throw new QueryException(MessageFormat.format("Left statement of an 'or' restriction must be another restriction. Found {0} instead", left));
        }
        if (!(right instanceof Restriction)) {
            throw new QueryException(MessageFormat.format("Right statement of an 'or' restriction must be another restriction. Found {0} instead", right));
        }
        return this.evaluate(object, (Restriction)left) || this.evaluate(object, (Restriction)right);
    }

    private boolean equals(Object object, Restriction r) {
        Object left = this.evaluate(object, r.getLeft());
        Object right = this.evaluate(object, r.getRight());
        if (left != null && right != null) {
            return left.equals(right);
        }
        return left == null && right == null;
    }

    private int evaluateComparison(Object object, Restriction r) {
        Object left = this.evaluate(object, r.getLeft());
        Object right = this.evaluate(object, r.getRight());
        if (left != null && right != null) {
            return ((Comparable)left).compareTo(right);
        }
        if (left == null && right == null) {
            return 0;
        }
        throw new QueryException(MessageFormat.format("Left could not be compared to write. Left: {0}, Right: {1}.", left, right));
    }

    private Object evaluate(Object object, Object expression) {
        if (expression instanceof Restriction.Property) {
            Serializable compiled = this.compiledExpressions.get((Restriction.Property)expression);
            Map vars = (Map)object;
            Object ctx = vars.get(this.queryBuilder.getAs());
            return MVEL.executeExpression((Object)compiled, ctx, (Map)vars);
        }
        return expression;
    }
}

