/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mql.mule;

import com.mulesoft.mql.LazyQueryContext;
import com.mulesoft.mql.Query;
import com.mulesoft.mql.mule.MuleClientWrapper;
import com.mulesoft.mql.mule.Type;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.api.transport.PropertyScope;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.module.json.transformers.JsonToObject;
import org.mule.module.json.transformers.ObjectToJson;
import org.mule.transformer.AbstractMessageTransformer;

public class MqlTransformer
extends AbstractMessageTransformer {
    private JsonToObject JSON_TO_OBJECT = new JsonToObject();
    private ObjectToJson OBJECT_TO_JSON = new ObjectToJson();
    private String query;
    private MuleClientWrapper clientWrapper;
    private Query compiledQuery;
    private Executor executor;
    private Type type = Type.POJO;

    public void initialise() throws InitialisationException {
        super.initialise();
        this.JSON_TO_OBJECT.setReturnClass(Object.class);
        this.JSON_TO_OBJECT.setMuleContext(this.muleContext);
        this.JSON_TO_OBJECT.initialise();
        this.OBJECT_TO_JSON.setMuleContext(this.muleContext);
        this.OBJECT_TO_JSON.initialise();
        this.clientWrapper = new MuleClientWrapper((MuleClient)new DefaultLocalMuleClient(this.muleContext));
        this.compiledQuery = Query.create((String)this.query);
        this.compiledQuery.setDefaultSelectObject("payload");
        if (this.executor != null) {
            this.compiledQuery.setExecutor(this.executor);
        }
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object payload = message.getPayload();
        boolean isJson = false;
        if (Type.JSON.equals((Object)this.type)) {
            isJson = true;
        } else if (Type.AUTO.equals((Object)this.type)) {
            String ct = (String)message.getOutboundProperty("Content-Type");
            if (ct == null && (ct = (String)message.getInvocationProperty("Content-Type")) == null) {
                ct = (String)message.getInboundProperty("Content-Type");
            }
            if (ct != null && ct.startsWith("application/json") && this.isData(message.getPayload())) {
                isJson = true;
            }
        }
        if (isJson) {
            if (payload instanceof OutputHandler) {
                try {
                    message.getPayloadAsString();
                }
                catch (Exception e) {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
            }
            payload = this.JSON_TO_OBJECT.transformMessage(message, outputEncoding);
        }
        MuleMessageQueryContext context = new MuleMessageQueryContext(message);
        context.put("payload", payload);
        context.put("message", message);
        context.put("mule", this.clientWrapper);
        Object result = this.compiledQuery.execute((Map)((Object)context));
        if (isJson) {
            message.setPayload(result);
            result = this.OBJECT_TO_JSON.transformMessage(message, outputEncoding);
        }
        return result;
    }

    private boolean isData(Object payload) {
        return payload instanceof InputStream || payload instanceof OutputHandler || payload instanceof String || payload instanceof byte[];
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public class MuleMessageQueryContext
    extends LazyQueryContext {
        private final MuleMessage message;

        public MuleMessageQueryContext(MuleMessage message) {
            this.message = message;
        }

        public Object load(String key) {
            Object object = this.message.getProperty(key, PropertyScope.OUTBOUND);
            if (object == null && (object = this.message.getProperty(key, PropertyScope.INVOCATION)) == null && (object = this.message.getProperty(key, PropertyScope.INBOUND)) == null) {
                object = MqlTransformer.this.muleContext.getRegistry().lookupObject(key);
            }
            return object;
        }
    }
}

