/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.datasense.impl.util.MutableHolder;

public abstract class PipedChainTypeResolver
extends StructuralNodeTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        List messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(Collectors.toList());
        MutableHolder<EventType> previousEventType = new MutableHolder<EventType>();
        for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
            EventType pipedInputEvent = previousEventType.getValue().orElse(inputEventType);
            EventType eventType2 = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
            previousEventType.setValue(eventType2);
        }
        EventType outputEventType = new EventType(previousEventType.getValue().map(eventType -> eventType.getVarDecls()).orElse(inputEventType.getVarDecls()));
        return outputEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

