/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.StructuralNodeTypeResolver;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class ScatterGatherTypeResolver
extends StructuralNodeTypeResolver {
    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
        ObjectTypeBuilder objectTypeBuilder = messageMetadataTypeBuilder.payload().objectType();
        messageMetadataTypeBuilder.attributes().voidType();
        ArrayList<EventType> nestedEventTypes = new ArrayList<EventType>();
        messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> {
            EventType nestedEventType = typingMuleAstVisitor.resolveType((AstNode)pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
            nestedEventTypes.add(nestedEventType);
            MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
            MetadataType routePayloadMetadataType = (MetadataType)TypeUtils.getMessageMetadataType(nestedEventType).flatMap(MessageMetadataType::getPayloadType).orElse(TypesHelper.getTypeBuilder().anyType().build());
            TypeUtils.getMessageMetadataType(nestedEventType).flatMap(MessageMetadataType::getAttributesType).ifPresent(arg_0 -> ((MessageMetadataTypeBuilder)routeMessageMetadataTypeBuilder).attributes(arg_0));
            routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);
            DefaultComponentLocation defaultComponentLocation = pipedMessageProcessorNode.getComponentModel().getComponentLocation();
            LocationPart[] parts = defaultComponentLocation.getParts().toArray(new LocationPart[defaultComponentLocation.getParts().size()]);
            String routeId = this.buildRouteId(parts);
            objectTypeBuilder.addField().required().key(routeId).value((MetadataType)routeMessageMetadataTypeBuilder.build());
        });
        EventType outputEventType = TypeUtils.merge(TypeUtils.union(nestedEventTypes), new EventType(TypeUtils.asVarDecls(messageMetadataTypeBuilder.build())));
        messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
        messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));
        return outputEventType;
    }

    private String buildRouteId(LocationPart[] parts) {
        return parts[parts.length - 1].getPartPath();
    }

    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected boolean isSequential() {
        return false;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }

    @Override
    protected boolean isScope() {
        return true;
    }
}

