/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.extension;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.config.api.dsl.model.ComponentModel;

public class ExtensionUtils {
    public static final String PARAMETER_TARGET = "target";
    public static final String PARAMETER_TARGET_VALUE = "targetValue";
    private static List<String> RESERVED_PARAMETERS = Arrays.asList("target", "targetValue");

    public static boolean isOutputParameter(String parameter) {
        return RESERVED_PARAMETERS.contains(parameter);
    }

    public static Optional<String> findParameter(ComponentModel componentModel, String parameter) {
        String result = null;
        if (componentModel != null) {
            result = (String)componentModel.getParameters().get(parameter);
        }
        return Optional.ofNullable(result);
    }

    public static Optional<ParameterModel> findParameter(ParameterizedModel parameterizedModel, String parameter) {
        return parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(parameter)).findFirst();
    }

    public static Optional<String> findDefaultTargetValue(ParameterizedModel parameterizedModel) {
        Object defaultTargetValue = ExtensionUtils.findParameter(parameterizedModel, PARAMETER_TARGET_VALUE).map(ParameterModel::getDefaultValue).orElse(null);
        return Optional.ofNullable(defaultTargetValue instanceof String ? (String)defaultTargetValue : null);
    }

    public static Optional<String> findTarget(ComponentModel componentModel) {
        return ExtensionUtils.findParameter(componentModel, PARAMETER_TARGET);
    }

    public static Optional<String> findTargetValue(ComponentModel componentModel) {
        return ExtensionUtils.findParameter(componentModel, PARAMETER_TARGET_VALUE);
    }
}

