/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/**
 *
 */
public class EventType {

  private List<VarDecl> varDecls;
  private Map<String, VarDecl> varDeclarationsByName;

  public EventType(Stream<VarDecl> varDeclarations) {
    Preconditions.checkNotNull(varDeclarations);
    this.varDecls = new ArrayList<>();
    this.varDeclarationsByName = new HashMap<>();
    varDeclarations.forEach(this::addVarDeclaration);
  }

  public EventType() {
    this(Collections.<VarDecl>emptySet().stream());
  }

  private void addVarDeclaration(VarDecl varDecl) {
    this.varDecls.add(varDecl);
    this.varDeclarationsByName.put(varDecl.getName(), varDecl);
  }

  public Stream<VarDecl> getVarDecls() {
    return varDecls.stream();
  }

  public Optional<VarDecl> get(String name) {
    return Optional.ofNullable(varDeclarationsByName.get(name));
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    EventType eventType = (EventType) o;

    return varDecls.equals(eventType.varDecls);

  }

  @Override
  public int hashCode() {
    return varDecls.hashCode();
  }

  @Override
  public String toString() {
    return "EventType{" +
        "varDeclarations=" + varDecls +
        '}';
  }
}
