package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;

import java.util.stream.Stream;

import static org.mule.datasense.impl.model.types.TypesHelper.MULE_EVENT_ERROR;

public class ErrorHandlerTypeResolver extends ProcessorChainTypeResolver {

  @Override
  protected boolean definesErrorHandlingContext() {
    return false;
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext typingMuleAstVisitorContext) {

    typingMuleAstVisitorContext.getErrorHandlingEnvironment().enterErrorHandling();
    final VarDecl errorVarDecl = inputEventType.get(MULE_EVENT_ERROR)
        .orElse(new VarDecl(MULE_EVENT_ERROR, TypesHelper.getTypeBuilder().voidType().build()));
    final EventType resolve =
        super.resolve(messageProcessorNode, inputEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
    return TypeUtils.merge(resolve, new EventType(Stream.of(errorVarDecl)));
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }

  protected boolean isScope() {
    return false;
  }

  @Override
  protected boolean isSequential() {
    return false;
  }
}
