package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

import java.util.Optional;

public class SchedulerTypeResolver extends PassThroughTypeResolver {

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext visitorContext) {

    messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
    final MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
    messageMetadataTypeBuilder.payload().voidType();
    //    messageMetadataTypeBuilder.attributes().voidType();
    messageProcessorNode
        .annotate(new DefinesTypeAnnotation(new EventType(TypeUtils.asVarDecls(messageMetadataTypeBuilder.build()))));

    return inputEventType;
  }


  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_SOURCE_NODE);
  }

}
