package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.datasense.impl.model.types.EventType;
import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ErrorHandlingEnvironment {

  private Deque<ErrorHandlingContext> errorHandlingContexts;

  public ErrorHandlingEnvironment() {
    errorHandlingContexts = new ArrayDeque<>();
  }

  public void pushContext(String id) {
    pushContext(id, new ErrorHandlingContext(id));
  }

  public void pushContext(String id, EventType argumentEventType) {
    pushContext(id, new ErrorHandlingContext(id, argumentEventType));
  }

  private void pushContext(String id, ErrorHandlingContext errorHandlingContext) {
    errorHandlingContexts.push(errorHandlingContext);
  }

  public void popContext() {
    final ErrorHandlingContext errorHandlingContext = errorHandlingContexts.pop();
    if (!errorHandlingContexts.isEmpty()) {
      throwErrors(errorHandlingContext.getUnhandledErrors());
    }
  }

  public ErrorHandlingContext getContext() {
    return errorHandlingContexts.peek();
  }

  public void enterErrorHandling() {
    getContext().close();
  }

  private ErrorHandlingContext findOpenContext() {
    for (ErrorHandlingContext errorHandlingContext : errorHandlingContexts) {
      if (errorHandlingContext.isOpen()) {
        return errorHandlingContext;
      }
    }
    throw new IllegalStateException();
  }

  public void throwErrors(Set<ErrorModel> errorModels) {
    findOpenContext().union(errorModels);
  }

  public void handleErrors(ErrorMatcher errorMatcher) {
    getContext().handle(errorMatcher);
  }

}
