package org.mule.datasense.impl.tooling;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.runtime.api.component.location.Location;

import java.util.Optional;

/**
 *
 */
public class NodeInfoQuery implements TypedApplicationQuery<NodeInfoQueryResult> {

  private final Location location;

  public NodeInfoQuery(
                       Location location) {
    this.location = location;
  }

  /**
   * @param muleApplicationNode
   * @param dataSenseProviderResolver
   * @param astNotification
   * @return
   */
  @Override
  public Optional<NodeInfoQueryResult> perform(MuleApplicationNode muleApplicationNode,
                                               DataSenseProviderResolver dataSenseProviderResolver,
                                               AstNotification astNotification) {
    return muleApplicationNode
        .findMessageProcessorNode(location)
        .map(messageProcessorNode -> messageProcessorNode.getAnnotation(ComponentLocationAnnotation.class)
            .map(componentPathAnnotation -> new NodeInfoQueryResult()))
        .orElse(Optional.empty());
  }
}
