package org.mule.datasense.impl.util;

import static java.util.Optional.empty;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ComponentModelUtils {

  public static Optional<Stream<ComponentAst>> collectComponentModels(MessageProcessorNode messageProcessorNode,
                                                                      Predicate<? super ComponentAst> childComponentFilter) {
    if (messageProcessorNode == null) {
      return empty();
    }
    final ComponentAst componentModel = messageProcessorNode.getComponentModel();
    if (componentModel == null) {
      return empty();
    }

    return Optional
        .of(componentModel.directChildrenStream()
            .filter(childComponentFilter));
  }

  public static Optional<Stream<ComponentAst>> collectComponentModelsById(MessageProcessorNode messageProcessorNode,
                                                                          ComponentIdentifier componentIdentifier) {
    if (componentIdentifier == null) {
      return empty();
    }
    return collectComponentModels(messageProcessorNode, componentModel -> componentIdentifier
        .equals(componentModel.getIdentifier()));
  }

  public static Optional<ComponentAst> collectComponentModelById(MessageProcessorNode messageProcessorNode,
                                                                 ComponentIdentifier componentIdentifier) {
    return collectComponentModelsById(messageProcessorNode, componentIdentifier).flatMap(Stream::findFirst);
  }
}
