/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.Set;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class FlowRefTypeResolver
extends SingleNodeTypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional definesTypeAnnotation = messageProcessorNode.getComponentModel().getParameter("name").getValue().mapRight(referredFlowName -> {
            Optional definesTypeAnnotationInner = Optional.empty();
            MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
            MuleFlowNode muleFlowNode = muleApplicationNode.findMuleFlowNode((String)referredFlowName).orElse(null);
            if (muleFlowNode != null) {
                messageProcessorNode.annotate(muleFlowNode.getAnnotation(UsesTypeAnnotation.class).orElse(new UsesTypeAnnotation(new EventType())));
                definesTypeAnnotationInner = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                if (!definesTypeAnnotationInner.isPresent()) {
                    typingMuleAstVisitor.resolveType(muleFlowNode, TypeUtils.createEventType(null), visitorContext.getAstNotification(), muleApplicationNode);
                    definesTypeAnnotationInner = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                }
                muleFlowNode.getAnnotation(ThrowsErrorsTypeAnnotation.class).map(ThrowsErrorsTypeAnnotation::getErrors).ifPresent(errorModels -> messageProcessorNode.annotate(new ThrowsErrorsTypeAnnotation((Set<ErrorModel>)errorModels)));
            } else {
                visitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Failed to solve flow-ref. Flow '%s' not found.", (Object[])new Object[]{referredFlowName}));
            }
            return definesTypeAnnotationInner.orElse(null);
        }).getValue();
        EventType definesEventType = definesTypeAnnotation.map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
        definesEventType = this.processTarget(definesEventType, messageProcessorNode, visitorContext);
        messageProcessorNode.annotate(new DefinesTypeAnnotation(definesEventType));
        return definesEventType;
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

