/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.ArrayList;
import java.util.Optional;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMapper;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMapping;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class ErrorMappingUtils {
    private static final ComponentIdentifier ERROR_MAPPING = ComponentIdentifierUtils.createFromNamespaceAndName("mule", "http://www.mulesoft.org/schema/mule/core", "error-mapping");
    private static final String ATTR_SOURCE_TYPE = "sourceType";
    private static final String ATTR_TARGET_TYPE = "targetType";

    public static Optional<ErrorMapping> createErrorMapping(ComponentAst componentModel) {
        if (!ERROR_MAPPING.equals(componentModel.getIdentifier())) {
            return Optional.empty();
        }
        return ErrorMapping.create(componentModel.getRawParameterValue(ATTR_SOURCE_TYPE).orElse(null), componentModel.getRawParameterValue(ATTR_TARGET_TYPE).orElse(null));
    }

    public static Optional<ErrorMapper> createErrorMapper(MessageProcessorNode messageProcessorNode) {
        ArrayList<ErrorMapping> errorMappings = new ArrayList<ErrorMapping>();
        Optional.ofNullable(messageProcessorNode.getComponentModel()).ifPresent(componentModel -> componentModel.directChildrenStream().forEach(childComponentModel -> ErrorMappingUtils.createErrorMapping(childComponentModel).ifPresent(errorMappings::add)));
        return Optional.ofNullable(errorMappings.isEmpty() ? null : new ErrorMapper(errorMappings));
    }
}

