package org.mule.datasense.impl.model.annotations;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;

import static org.mule.datasense.impl.util.LocationUtils.valueOf;

public class ComponentLocationAnnotation implements AstNodeAnnotation {

  private final ComponentLocation componentLocation;
  private final Location location;

  public ComponentLocationAnnotation(ComponentLocation componentLocation) {
    Preconditions.checkNotNull(componentLocation);
    this.componentLocation = componentLocation;
    location = valueOf(componentLocation.getLocation());
  }

  public Location getLocation() {
    return location;
  }

  public ComponentLocation getComponentLocation() {
    return componentLocation;
  }
}
