package org.mule.datasense.impl.model.annotations;

import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.util.extension.OutputModelTransform;
import org.mule.datasense.impl.util.extension.ParameterGroupModelTransform;
import org.mule.datasense.impl.util.extension.SourceCallbackModelTransform;
import org.mule.datasense.impl.util.extension.SourceModelTransform;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKey;

import java.util.Map;
import java.util.Set;

public class SourceModelMetadataKeyEnricher extends ComponentModelMetadataKeyEnricher<SourceModel> {

  protected SourceModel enrich(SourceModel componentModel, Map<String, Set<MetadataKey>> metadataKeysByPart,
                               OperationCall operationCall) {
    if (metadataKeysByPart == null && operationCall == null) {
      return componentModel;
    }

    final SourceModelTransform sourceModelTransform = new SourceModelTransform(
                                                                               new ParameterGroupModelTransform(getParameterModelMetadataTypeFunction(metadataKeysByPart,
                                                                                                                                                      operationCall)),
                                                                               new OutputModelTransform(getOutputMetadataTypeFunction(operationCall)),
                                                                               new OutputModelTransform(getOutputAttributesMetadataTypeFunction(operationCall)),
                                                                               new SourceCallbackModelTransform(),
                                                                               new SourceCallbackModelTransform(),
                                                                               new SourceCallbackModelTransform());
    return sourceModelTransform.transform(componentModel);
  }
}
