package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class DefVariable implements DefElem {

  private final String name;
  private final DefElemValueExpr value;

  public DefVariable(String name, DefElemValueExpr value) {
    Preconditions.checkNotNull(name);
    Preconditions.checkState(!name.isEmpty());
    Preconditions.checkNotNull(value);
    this.name = name;
    this.value = value;
  }

  @Override
  public void resolveType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                          MuleEventMetadataType muleEventMetadataType,
                          ResolveTypeContext resolveTypeContext) {
    muleEventMetadataTypeBuilder.addVariable(name, value.resolveType(muleEventMetadataType, resolveTypeContext));
  }

  @Override
  public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
    final MetadataType metadataType =
        muleEventMetadataType.getVariables().getFieldByName(name).map(objectFieldType -> objectFieldType.getValue())
            .orElse(TypesHelper.getTypeBuilder().anyType().build());
    value.resolveInputType(muleEventMetadataTypeBuilder, metadataType, resolveTypeContext);
  }
}
