package org.mule.datasense.impl.model.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MuleEventExprBuilder {

  private DefMessageBuilder defMessageBuilder;

  private final Map<String, DefVariableBuilder> defVariableBuilderMap;

  public MuleEventExprBuilder() {
    defVariableBuilderMap = new HashMap<>();
    defMessageBuilder = new DefMessageBuilder();
  }

  public MuleEventExprBuilder message(Consumer<DefMessageBuilder> defMessageBuilderConsumer) {
    if (this.defMessageBuilder == null) {
      this.defMessageBuilder = new DefMessageBuilder();
    }
    defMessageBuilderConsumer.accept(defMessageBuilder);
    return this;
  }

  public MuleEventExprBuilder variable(String name, Consumer<DefVariableBuilder> defVariableBuilderConsumer) {
    DefVariableBuilder defVariableBuilder = new DefVariableBuilder(name);
    defVariableBuilderConsumer.accept(defVariableBuilder);
    defVariableBuilderMap.put(defVariableBuilder.getName(), defVariableBuilder);
    return this;
  }

  public MuleEventExpr build() {
    Stream<DefElem> build = defMessageBuilder.build().map(Stream::of).orElse(Stream.empty());
    Stream<DefElem> collect =
        defVariableBuilderMap.values().stream()
            .map(DefVariableBuilder::build)
            .filter(Optional::isPresent)
            .map(Optional::get);
    return new MuleEventExpr(Stream.concat(build, collect).collect(Collectors.toList()));
  }
}
