package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

public class StaticOperationAnnotator extends BaseStaticAnnotator {

  @Override
  protected Optional<ComponentModel> resolveComponentModel(MessageProcessorNode messageProcessorNode,
                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                           DataSenseProviderResolver dataSenseProviderResolver,
                                                           ComponentAst componentModel) {
    return dataSenseProviderResolver.resolveOperationModel(componentModel)
        .map(operationModel -> {
          messageProcessorNode.annotate(new OperationModelAnnotation(operationModel));
          return (ComponentModel) operationModel;
        });
  }
}
