package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

public class StaticSourceAnnotator extends BaseStaticAnnotator {

  @Override
  protected Optional<ComponentModel> resolveComponentModel(MessageProcessorNode messageProcessorNode,
                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                           DataSenseProviderResolver dataSenseProviderResolver,
                                                           ComponentAst componentModel) {
    return dataSenseProviderResolver.resolveSourceModel(componentModel)
        .map(sourceModel -> {
          messageProcessorNode.annotate(new SourceModelAnnotation(sourceModel));
          return (ComponentModel) sourceModel;
        });
  }
}
