package org.mule.datasense.impl.util.extension;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class ParameterGroupModelTransform {

  private Function<ParameterModel, MetadataType> typeTransform;

  public ParameterGroupModelTransform() {
    this(null);
  }

  public ParameterGroupModelTransform(
                                      Function<ParameterModel, MetadataType> typeTransform) {
    this.typeTransform = typeTransform;
  }

  private Optional<Function<ParameterModel, MetadataType>> getTypeTransform() {
    return Optional.ofNullable(typeTransform);
  }


  public List<ParameterGroupModel> transform(List<ParameterGroupModel> parameterGroupModels) {
    List<ParameterGroupModel> parameterGroups = new LinkedList<>();
    parameterGroupModels.forEach(parameterGroup -> {
      List<ParameterModel> parameters = new LinkedList<>();
      parameterGroup.getParameterModels().forEach(parameterModel -> {
        ParameterModel typedParameterModel =
            new ImmutableParameterModel(parameterModel.getName(), parameterModel.getDescription(),
                                        getTypeTransform()
                                            .map(parameterModelMetadataTypeFunction -> parameterModelMetadataTypeFunction
                                                .apply(parameterModel))
                                            .orElse(parameterModel.getType()),
                                        parameterModel.hasDynamicType(),
                                        parameterModel.isRequired(),
                                        parameterModel.isOverrideFromConfig(),
                                        parameterModel.isComponentId(),
                                        parameterModel.getExpressionSupport(),
                                        parameterModel.getDefaultValue(),
                                        parameterModel.getRole(),
                                        parameterModel.getDslConfiguration(),
                                        parameterModel.getDisplayModel().orElse(null),
                                        parameterModel.getLayoutModel().orElse(null),
                                        parameterModel.getValueProviderModel().orElse(null),
                                        parameterModel.getAllowedStereotypes(),
                                        parameterModel.getModelProperties());
        parameters.add(typedParameterModel);
      });

      parameterGroups
          .add(new ImmutableParameterGroupModel(parameterGroup.getName(), parameterGroup.getDescription(), parameters,
                                                parameterGroup.getExclusiveParametersModels(),
                                                parameterGroup.isShowInDsl(), parameterGroup.getDisplayModel().orElse(null),
                                                parameterGroup.getLayoutModel().orElse(null),
                                                parameterGroup.getModelProperties()));
    });
    return parameterGroups;
  }
}
