package org.mule.datasense.api.metadataprovider;

import static java.util.Optional.ofNullable;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;

import java.util.Optional;
import java.util.Set;

import com.google.common.base.Preconditions;

public class DefaultDataSenseProvider implements DataSenseProvider {

  private final ExtensionsProvider extensionsProvider;
  private final DataSenseMetadataProvider dataSenseMetadataProvider;
  private final MetadataBuilder apikitMetadataBuilder;
  private final DataSenseConfiguration dataSenseConfiguration;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public DefaultDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataProvider dataSenseMetadataProvider,
                                  DataSenseConfiguration dataSenseConfiguration,
                                  ExpressionLanguageMetadataService expressionLanguageMetadataService,
                                  MetadataBuilder apikitMetadataBuilder) {
    Preconditions.checkNotNull(extensionsProvider);
    this.extensionsProvider = extensionsProvider;
    this.dataSenseMetadataProvider = dataSenseMetadataProvider;
    this.dataSenseConfiguration = dataSenseConfiguration;
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    this.apikitMetadataBuilder = apikitMetadataBuilder;
  }

  @Override
  public Set<ExtensionModel> getExtensions() {
    return extensionsProvider.getExtensions();
  }

  @Override
  public Optional<DataSenseMetadataProvider> getDataSenseMetadataProvider() {
    return ofNullable(dataSenseMetadataProvider);
  }

  @Override
  public MetadataBuilder getApikitMetadataBuilder() {
    return apikitMetadataBuilder;
  }

  @Override
  public Optional<DataSenseConfiguration> getDataSenseConfiguration() {
    return ofNullable(dataSenseConfiguration);
  }

  @Override
  public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
    return expressionLanguageMetadataService;
  }

}
