package org.mule.datasense.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataSenseModuleRegistry {

  private DataSenseModuleLoader dataSenseModuleLoader;
  private List<DataSenseModule> dataSenseModuleList;

  public DataSenseModuleRegistry() {
    dataSenseModuleList = new ArrayList<>();
    dataSenseModuleLoader = new DataSenseModuleLoader();
    initialize();
  }

  private void initialize() {
    dataSenseModuleList = dataSenseModuleLoader.loadModules().collect(Collectors.toList());
  }

  public Stream<DataSenseModule> getDataSenseModules() {
    return dataSenseModuleList.stream();
  }
}
