/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl;

import org.mule.datasense.api.DataSenseElementInfo;
import org.mule.datasense.api.DataSenseComponentInfo;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.notifications.DataSenseNotification;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 *
 */
public class DefaultDataSenseInfo implements DataSenseInfo, DataSenseComponentInfo, DataSenseElementInfo {

  private final Location location;
  private final OperationModel operationModel;
  private final SourceModel sourceModel;
  private final MetadataType input;
  private final MetadataType output;
  private final MetadataType incoming;
  private final MetadataType expected;
  private final MetadataType result;
  private final MetadataType expectedInput;
  private final List<String> messages;
  private final List<DataSenseNotification> dataSenseNotifications;
  private final Map<Location, DataSenseElementInfo> componentInfoByComponentPath;
  private final Map<String, MetadataType> globalBindings;
  private final Map<String, MetadataType> functionBindings;

  public DefaultDataSenseInfo(Location location, OperationModel operationModel, SourceModel sourceModel,
                              MetadataType input, MetadataType output, MetadataType incoming,
                              MetadataType expected, MetadataType result, MetadataType expectedInput, List<String> messages,
                              List<DataSenseNotification> dataSenseNotifications,
                              Map<Location, DataSenseElementInfo> componentInfoByComponentPath,
                              Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings) {
    this.location = location;
    this.operationModel = operationModel;
    this.sourceModel = sourceModel;
    this.input = input;
    this.output = output;
    this.incoming = incoming;
    this.expected = expected;
    this.result = result;
    this.expectedInput = expectedInput;
    this.componentInfoByComponentPath = componentInfoByComponentPath;
    if (messages != null) {
      this.messages = new ArrayList<>(messages.size());
      this.messages.addAll(messages);
    } else {
      this.messages = new ArrayList<>();
    }
    if (dataSenseNotifications != null) {
      this.dataSenseNotifications = new ArrayList<>(dataSenseNotifications.size());
      this.dataSenseNotifications.addAll(dataSenseNotifications);
    } else {
      this.dataSenseNotifications = new ArrayList<>();
    }
    this.globalBindings = new HashMap<>();
    if (globalBindings != null) {
      this.globalBindings.putAll(globalBindings);
    }
    this.functionBindings = new HashMap<>();
    if (functionBindings != null) {
      this.functionBindings.putAll(functionBindings);
    }
  }

  public DefaultDataSenseInfo(Location location, OperationModel operationModel, SourceModel sourceModel,
                              MetadataType input, MetadataType output, MetadataType incoming,
                              MetadataType expected, MetadataType result, MetadataType expectedInput, List<String> messages,
                              List<DataSenseNotification> dataSenseNotifications,
                              Map<Location, DataSenseElementInfo> componentInfoByComponentPath) {
    this(location, operationModel, sourceModel,
         input, output, incoming,
         expected, result, expectedInput, messages,
         dataSenseNotifications,
         componentInfoByComponentPath, null, null);
  }

  @Override
  public Location getLocation() {
    return location;
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<MetadataType> getInput() {
    return Optional.ofNullable(input);
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<MetadataType> getOutput() {
    return Optional.ofNullable(output);
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<MetadataType> getIncoming() {
    return Optional.ofNullable(incoming);
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<MetadataType> getExpected() {
    return Optional.ofNullable(expected);
  }

  /**
   *
   * @return
   */
  @Override
  public Optional<MetadataType> getActualInput() {
    return getIncoming();
  }

  /**
   *
   * @return
   */
  @Override
  public Optional<MetadataType> getActualOutput() {
    return getResult();
  }

  /**
   *
   * @return
   */
  @Override
  public Optional<MetadataType> getExpectedInput() {
    return Optional.ofNullable(expectedInput);
  }

  /**
   *
   * @return
   */
  @Override
  public Optional<MetadataType> getExpectedOutput() {
    return getExpected();
  }

  /**
   *
   * @return
   */
  @Override
  public Optional<MetadataType> getResult() {
    return Optional.ofNullable(result);
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<OperationModel> getOperationModel() {
    return Optional.ofNullable(operationModel);
  }

  /**
   *
   * @return
     */
  @Override
  public Optional<SourceModel> getSourceModel() {
    return Optional.ofNullable(sourceModel);
  }

  public List<String> getMessages() {
    return messages;
  }

  public List<DataSenseNotification> getDataSenseNotifications() {
    return dataSenseNotifications;
  }

  public Optional<Map<Location, DataSenseElementInfo>> getComponentInfoByComponentPath() {
    return Optional.ofNullable(componentInfoByComponentPath);
  }

  @Override
  public Map<String, MetadataType> getGlobalBindings() {
    return globalBindings;
  }

  @Override
  public Map<String, MetadataType> getFunctionBindings() {
    return functionBindings;
  }
}
