package org.mule.datasense.impl.model.event;

import java.util.Optional;

public class DefVariableBuilder implements DefElemBuilder {

  private String name;
  private DefElemValueExprBuilder value;

  public DefVariableBuilder(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public DefVariableBuilder value(DefElemValueExprBuilder defElemValueExprBuilder) {
    this.value = defElemValueExprBuilder;
    return this;
  }

  private boolean isValid() {
    return name != null && !name.isEmpty();
  }

  @Override
  public Optional<DefElem> build() {
    return isValid() ? Optional.of(new DefVariable(name, value.build())) : Optional.empty();
  }
}
