package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

import java.util.ArrayList;
import java.util.List;

public class AnnotatorsRegistry {

  private final List<Annotator> annotators;

  public AnnotatorsRegistry() {
    annotators = new ArrayList<>();
  }

  public void add(Annotator annotator) {
    annotators.add(annotator);
  }

  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    annotators.forEach(annotator -> annotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext));
  }

  public void annotate(MuleFlowNode muleFlowNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    annotators.forEach(annotator -> annotator.annotate(muleFlowNode, annotatingMuleAstVisitorContext));
  }

  public void annotate(MuleApplicationNode muleApplicationNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    annotators.forEach(annotator -> annotator.annotate(muleApplicationNode, annotatingMuleAstVisitorContext));
  }
}
