package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;

public class MessageProcessorTypeDeclarationAnnotator extends BaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    if (!messageProcessorNode.isSynthetic()) {
      annotatingMuleAstVisitorContext.getDataSenseProviderResolver()
          .findMessageProcessorTypeDeclaration(messageProcessorNode.getComponentModel())
          .ifPresent(messageProcessorTypeDeclaration -> {
            messageProcessorNode.annotate(new MessageProcessorTypeDeclarationAnnotation(messageProcessorTypeDeclaration));
          });
    }
  }
}
