package org.mule.datasense.impl.phases.scoping;

import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.BaseAstNodeVisitorContext;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class IncomingAstVisitorContext extends BaseAstNodeVisitorContext {

  private EventType incomingEventType;

  public IncomingAstVisitorContext(TypeResolverRegistry typeResolverRegistry, AstNotification astNotification,
                                   ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    super(typeResolverRegistry, astNotification, expressionLanguageMetadataService);
  }


  public void setIncomingEventType(EventType incomingEventType) {
    this.incomingEventType = incomingEventType;
  }

  public EventType getIncomingEventType() {
    return incomingEventType;
  }
}
