package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.util.MutableHolder;

import java.util.List;
import java.util.stream.Collectors;

public abstract class PipedChainTypeResolver extends StructuralNodeTypeResolver {

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext typingMuleAstVisitorContext) {
    List<MessageProcessorNode> messageProcessorNodes = messageProcessorNode.getMessageProcessorNodes().collect(
                                                                                                               Collectors
                                                                                                                   .toList());

    // = proceed typing piped children mps
    //    Optional<MessageProcessorNode> previousMessageProcessorNode = Optional.empty();
    MutableHolder<EventType> previousEventType = new MutableHolder<>();
    for (MessageProcessorNode pipedMessageProcessorNode : messageProcessorNodes) {
      //
      EventType pipedInputEvent = previousEventType.getValue().orElse(inputEventType);

      // unify input event with declared lambda
      EventType eventType =
          typingMuleAstVisitor.resolveType(pipedMessageProcessorNode, pipedInputEvent, typingMuleAstVisitorContext);
      // unify output event with declared lambda
      previousEventType.setValue(eventType);
    }

    final EventType outputEventType = new EventType(
                                                    previousEventType.getValue().map(eventType -> eventType.getVarDecls())
                                                        .orElse(inputEventType.getVarDecls()));

    return outputEventType;
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }
}
