package org.mule.datasense.impl.phases.typing.resolver.batch;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.resolver.PipedChainTypeResolver;

import java.util.Optional;

public class BatchProcessRecordsTypeResolver extends PipedChainTypeResolver {

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return false;
  }

  /*
  @Override
  public Optional<MuleAstParseProvider> getParseProvider() {
    return Optional.of(
                       (componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders,
                        muleAstParserContext) -> {
                         return generateAst(componentIdentifier, componentModel, componentModelType,
                                            messageProcessorNodeBuilders);
                       });
  }
  
  private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentModel componentModel,
                                               ComponentModelType componentModelType,
                                               List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
    MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
    messageProcessorNodeBuilder.config(componentModel);
    messageProcessorNodeBuilder.componentModelType(componentModelType);
    for (MessageProcessorNodeBuilder childMessageProcessorNodeBuilder : messageProcessorNodeBuilders) {
      Optional<MessageProcessorNodeBuilder> maybeAggregator = Optional.empty();
      if (childMessageProcessorNodeBuilder.getComponentIdentifier().equals(COMPONENT_IDENTIFIER_BATCH_STEP)) {
        MessageProcessorNodeBuilder step = childMessageProcessorNodeBuilder;
        final List<MessageProcessorNodeBuilder> elements = step.getMessageProcessorNodeBuilderList();
        if (!elements.isEmpty()) {
          final MessageProcessorNodeBuilder lastElement = elements.get(elements.size() - 1);
          if (lastElement.getComponentIdentifier().equals(COMPONENT_IDENTIFIER_BATCH_AGGREGATOR)) {
            elements.remove(lastElement);
            maybeAggregator = Optional.of(lastElement);
          }
        }
      }
      messageProcessorNodeBuilder.messageProcessor(childMessageProcessorNodeBuilder);
      maybeAggregator.ifPresent(messageProcessorNodeBuilder::messageProcessor);
    }
    return Optional.of(messageProcessorNodeBuilder);
  }
  */

}
